package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InputDataConfig(
    datasetGroupArn: Arn,
    supplementaryFeatures: Optional[
      Iterable[zio.aws.forecast.model.SupplementaryFeature]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.InputDataConfig = {
    import InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.InputDataConfig
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .optionallyWith(
        supplementaryFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supplementaryFeatures)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.InputDataConfig.ReadOnly =
    zio.aws.forecast.model.InputDataConfig.wrap(buildAwsValue())
}
object InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.InputDataConfig =
      zio.aws.forecast.model.InputDataConfig(
        datasetGroupArn,
        supplementaryFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetGroupArn: Arn
    def supplementaryFeatures
        : Optional[List[zio.aws.forecast.model.SupplementaryFeature.ReadOnly]]
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getSupplementaryFeatures: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.SupplementaryFeature.ReadOnly
    ]] =
      AwsError.unwrapOptionField("supplementaryFeatures", supplementaryFeatures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.InputDataConfig
  ) extends zio.aws.forecast.model.InputDataConfig.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetGroupArn())
    override val supplementaryFeatures
        : Optional[List[zio.aws.forecast.model.SupplementaryFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supplementaryFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.SupplementaryFeature.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.InputDataConfig
  ): zio.aws.forecast.model.InputDataConfig.ReadOnly = new Wrapper(impl)
}
