package zio.aws.forecast.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDatasetGroupsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest = {
    import ListDatasetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListDatasetGroupsRequest.ReadOnly =
    zio.aws.forecast.model.ListDatasetGroupsRequest.wrap(buildAwsValue())
}
object ListDatasetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListDatasetGroupsRequest =
      zio.aws.forecast.model.ListDatasetGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest
  ) extends zio.aws.forecast.model.ListDatasetGroupsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.forecast.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest
  ): zio.aws.forecast.model.ListDatasetGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
