package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPredictorsResponse(
    predictors: Optional[Iterable[zio.aws.forecast.model.PredictorSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListPredictorsResponse = {
    import ListPredictorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListPredictorsResponse
      .builder()
      .optionallyWith(
        predictors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predictors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListPredictorsResponse.ReadOnly =
    zio.aws.forecast.model.ListPredictorsResponse.wrap(buildAwsValue())
}
object ListPredictorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListPredictorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListPredictorsResponse =
      zio.aws.forecast.model.ListPredictorsResponse(
        predictors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def predictors
        : Optional[List[zio.aws.forecast.model.PredictorSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPredictors: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.PredictorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("predictors", predictors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListPredictorsResponse
  ) extends zio.aws.forecast.model.ListPredictorsResponse.ReadOnly {
    override val predictors
        : Optional[List[zio.aws.forecast.model.PredictorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.PredictorSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListPredictorsResponse
  ): zio.aws.forecast.model.ListPredictorsResponse.ReadOnly = new Wrapper(impl)
}
