package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.forecast.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListTagsForResourceRequest =
      zio.aws.forecast.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest
  ) extends zio.aws.forecast.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest
  ): zio.aws.forecast.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
