package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Metrics(
    rmse: Optional[Double] = Optional.Absent,
    weightedQuantileLosses: Optional[
      Iterable[zio.aws.forecast.model.WeightedQuantileLoss]
    ] = Optional.Absent,
    errorMetrics: Optional[Iterable[zio.aws.forecast.model.ErrorMetric]] =
      Optional.Absent,
    averageWeightedQuantileLoss: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.Metrics = {
    import Metrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Metrics
      .builder()
      .optionallyWith(rmse.map(value => value: java.lang.Double))(_.rmse)
      .optionallyWith(
        weightedQuantileLosses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.weightedQuantileLosses)
      .optionallyWith(
        errorMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorMetrics)
      .optionallyWith(
        averageWeightedQuantileLoss.map(value => value: java.lang.Double)
      )(_.averageWeightedQuantileLoss)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Metrics.ReadOnly =
    zio.aws.forecast.model.Metrics.wrap(buildAwsValue())
}
object Metrics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.Metrics] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Metrics =
      zio.aws.forecast.model.Metrics(
        rmse.map(value => value),
        weightedQuantileLosses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errorMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        averageWeightedQuantileLoss.map(value => value)
      )
    def rmse: Optional[Double]
    def weightedQuantileLosses
        : Optional[List[zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly]]
    def errorMetrics
        : Optional[List[zio.aws.forecast.model.ErrorMetric.ReadOnly]]
    def averageWeightedQuantileLoss: Optional[Double]
    def getRmse: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("rmse", rmse)
    def getWeightedQuantileLosses: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "weightedQuantileLosses",
      weightedQuantileLosses
    )
    def getErrorMetrics: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ErrorMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("errorMetrics", errorMetrics)
    def getAverageWeightedQuantileLoss: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "averageWeightedQuantileLoss",
        averageWeightedQuantileLoss
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Metrics
  ) extends zio.aws.forecast.model.Metrics.ReadOnly {
    override val rmse: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.rmse())
      .map(value => value: Double)
    override val weightedQuantileLosses
        : Optional[List[zio.aws.forecast.model.WeightedQuantileLoss.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weightedQuantileLosses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.WeightedQuantileLoss.wrap(item)
          }.toList
        )
    override val errorMetrics
        : Optional[List[zio.aws.forecast.model.ErrorMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.ErrorMetric.wrap(item)
          }.toList
        )
    override val averageWeightedQuantileLoss: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.averageWeightedQuantileLoss())
        .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Metrics
  ): zio.aws.forecast.model.Metrics.ReadOnly = new Wrapper(impl)
}
