package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait OptimizationMetric {
  def unwrap: software.amazon.awssdk.services.forecast.model.OptimizationMetric
}
object OptimizationMetric {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.OptimizationMetric
  ): zio.aws.forecast.model.OptimizationMetric = value match {
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.WAPE =>
      val r = WAPE
      r
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.RMSE =>
      val r = RMSE
      r
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.AVERAGE_WEIGHTED_QUANTILE_LOSS =>
      val r = AverageWeightedQuantileLoss
      r
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.MASE =>
      val r = MASE
      r
    case software.amazon.awssdk.services.forecast.model.OptimizationMetric.MAPE =>
      val r = MAPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.UNKNOWN_TO_SDK_VERSION
  }
  case object WAPE extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.WAPE
  }
  case object RMSE extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.RMSE
  }
  case object AverageWeightedQuantileLoss
      extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.AVERAGE_WEIGHTED_QUANTILE_LOSS
  }
  case object MASE extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.MASE
  }
  case object MAPE extends zio.aws.forecast.model.OptimizationMetric {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.OptimizationMetric =
      software.amazon.awssdk.services.forecast.model.OptimizationMetric.MAPE
  }
}
