package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParameterRanges(
    categoricalParameterRanges: Optional[
      Iterable[zio.aws.forecast.model.CategoricalParameterRange]
    ] = Optional.Absent,
    continuousParameterRanges: Optional[
      Iterable[zio.aws.forecast.model.ContinuousParameterRange]
    ] = Optional.Absent,
    integerParameterRanges: Optional[
      Iterable[zio.aws.forecast.model.IntegerParameterRange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ParameterRanges = {
    import ParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ParameterRanges
      .builder()
      .optionallyWith(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalParameterRanges)
      .optionallyWith(
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousParameterRanges)
      .optionallyWith(
        integerParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ParameterRanges.ReadOnly =
    zio.aws.forecast.model.ParameterRanges.wrap(buildAwsValue())
}
object ParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ParameterRanges =
      zio.aws.forecast.model.ParameterRanges(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        integerParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def categoricalParameterRanges: Optional[
      List[zio.aws.forecast.model.CategoricalParameterRange.ReadOnly]
    ]
    def continuousParameterRanges: Optional[
      List[zio.aws.forecast.model.ContinuousParameterRange.ReadOnly]
    ]
    def integerParameterRanges
        : Optional[List[zio.aws.forecast.model.IntegerParameterRange.ReadOnly]]
    def getCategoricalParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.CategoricalParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalParameterRanges",
      categoricalParameterRanges
    )
    def getContinuousParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ContinuousParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousParameterRanges",
      continuousParameterRanges
    )
    def getIntegerParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.IntegerParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerParameterRanges",
      integerParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ParameterRanges
  ) extends zio.aws.forecast.model.ParameterRanges.ReadOnly {
    override val categoricalParameterRanges: Optional[
      List[zio.aws.forecast.model.CategoricalParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.categoricalParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.CategoricalParameterRange.wrap(item)
        }.toList
      )
    override val continuousParameterRanges: Optional[
      List[zio.aws.forecast.model.ContinuousParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.ContinuousParameterRange.wrap(item)
        }.toList
      )
    override val integerParameterRanges: Optional[
      List[zio.aws.forecast.model.IntegerParameterRange.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.integerParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.IntegerParameterRange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ParameterRanges
  ): zio.aws.forecast.model.ParameterRanges.ReadOnly = new Wrapper(impl)
}
