package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait State {
  def unwrap: software.amazon.awssdk.services.forecast.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.State
  ): zio.aws.forecast.model.State = value match {
    case software.amazon.awssdk.services.forecast.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.State.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.forecast.model.State.DELETED =>
      val r = Deleted
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.State {
    override def unwrap: software.amazon.awssdk.services.forecast.model.State =
      software.amazon.awssdk.services.forecast.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.forecast.model.State {
    override def unwrap: software.amazon.awssdk.services.forecast.model.State =
      software.amazon.awssdk.services.forecast.model.State.ACTIVE
  }
  case object Deleted extends zio.aws.forecast.model.State {
    override def unwrap: software.amazon.awssdk.services.forecast.model.State =
      software.amazon.awssdk.services.forecast.model.State.DELETED
  }
}
