package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait TimeSeriesGranularity {
  def unwrap
      : software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity
}
object TimeSeriesGranularity {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity
  ): zio.aws.forecast.model.TimeSeriesGranularity = value match {
    case software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.SPECIFIC =>
      val r = SPECIFIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.TimeSeriesGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity =
      software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.forecast.model.TimeSeriesGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity =
      software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.ALL
  }
  case object SPECIFIC extends zio.aws.forecast.model.TimeSeriesGranularity {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity =
      software.amazon.awssdk.services.forecast.model.TimeSeriesGranularity.SPECIFIC
  }
}
