package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetGroupRequest(
    datasetGroupArn: Arn,
    datasetArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest = {
    import UpdateDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .datasetArns(datasetArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.UpdateDatasetGroupRequest.ReadOnly =
    zio.aws.forecast.model.UpdateDatasetGroupRequest.wrap(buildAwsValue())
}
object UpdateDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.UpdateDatasetGroupRequest =
      zio.aws.forecast.model
        .UpdateDatasetGroupRequest(datasetGroupArn, datasetArns)
    def datasetGroupArn: Arn
    def datasetArns: List[Arn]
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
    def getDatasetArns: ZIO[Any, Nothing, List[Arn]] = ZIO.succeed(datasetArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest
  ) extends zio.aws.forecast.model.UpdateDatasetGroupRequest.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetGroupArn())
    override val datasetArns: List[Arn] = impl
      .datasetArns()
      .asScala
      .map { item =>
        zio.aws.forecast.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest
  ): zio.aws.forecast.model.UpdateDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
