package zio.aws.forecast
import zio.aws.forecast.model.DescribePredictorResponse.ReadOnly
import zio.aws.forecast.model.{
  ListExplainabilitiesRequest,
  ResumeResourceRequest,
  DeleteForecastExportJobRequest,
  DescribeForecastExportJobRequest,
  CreateAutoPredictorRequest,
  CreateDatasetRequest,
  ListForecastsRequest,
  DescribeDatasetGroupRequest,
  ListPredictorsRequest,
  DeleteWhatIfAnalysisRequest,
  ListWhatIfAnalysesRequest,
  DeleteWhatIfForecastExportRequest,
  DeleteResourceTreeRequest,
  DeleteDatasetImportJobRequest,
  DeleteMonitorRequest,
  DeleteDatasetGroupRequest,
  ListMonitorEvaluationsRequest,
  CreatePredictorBacktestExportJobRequest,
  CreatePredictorRequest,
  CreateWhatIfAnalysisRequest,
  DescribeDatasetRequest,
  ListTagsForResourceRequest,
  ListDatasetImportJobsRequest,
  DescribeDatasetImportJobRequest,
  DeleteWhatIfForecastRequest,
  CreateDatasetGroupRequest,
  DescribeWhatIfAnalysisRequest,
  ListDatasetsRequest,
  GetAccuracyMetricsRequest,
  DeleteExplainabilityExportRequest,
  DescribeExplainabilityExportRequest,
  DescribeWhatIfForecastRequest,
  DescribeMonitorRequest,
  ListMonitorsRequest,
  CreateExplainabilityRequest,
  DeleteForecastRequest,
  DeletePredictorRequest,
  DescribePredictorRequest,
  UpdateDatasetGroupRequest,
  ListWhatIfForecastExportsRequest,
  CreateWhatIfForecastRequest,
  CreateForecastExportJobRequest,
  DeleteDatasetRequest,
  ListForecastExportJobsRequest,
  StopResourceRequest,
  CreateExplainabilityExportRequest,
  UntagResourceRequest,
  ListWhatIfForecastsRequest,
  ListDatasetGroupsRequest,
  DescribeForecastRequest,
  DescribeExplainabilityRequest,
  DescribePredictorBacktestExportJobRequest,
  CreateForecastRequest,
  CreateWhatIfForecastExportRequest,
  DeleteExplainabilityRequest,
  DeletePredictorBacktestExportJobRequest,
  ListPredictorBacktestExportJobsRequest,
  ListExplainabilityExportsRequest,
  TagResourceRequest,
  CreateDatasetImportJobRequest,
  DescribeWhatIfForecastExportRequest,
  DescribeAutoPredictorRequest,
  CreateMonitorRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.forecast.model.{
  PredictorBacktestExportJobSummary,
  CreateWhatIfAnalysisResponse,
  DescribeForecastResponse,
  ListForecastsResponse,
  DatasetSummary,
  DatasetGroupSummary,
  DescribeDatasetResponse,
  ListDatasetGroupsResponse,
  ListPredictorBacktestExportJobsResponse,
  ListMonitorsResponse,
  WhatIfAnalysisSummary,
  DeleteMonitorResponse,
  DescribePredictorResponse,
  ResumeResourceResponse,
  DescribeWhatIfForecastExportResponse,
  DescribeWhatIfAnalysisResponse,
  DeleteDatasetGroupResponse,
  PredictorSummary,
  CreateExplainabilityResponse,
  DeleteForecastResponse,
  DeleteResourceTreeResponse,
  PredictorMonitorEvaluation,
  ListExplainabilityExportsResponse,
  DeleteWhatIfForecastResponse,
  DeleteExplainabilityResponse,
  ListPredictorsResponse,
  WhatIfForecastSummary,
  DeletePredictorBacktestExportJobResponse,
  ExplainabilityExportSummary,
  ListDatasetImportJobsResponse,
  DescribeDatasetGroupResponse,
  DeleteWhatIfAnalysisResponse,
  CreateDatasetResponse,
  ListMonitorEvaluationsResponse,
  DescribeAutoPredictorResponse,
  UpdateDatasetGroupResponse,
  CreateDatasetImportJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListWhatIfAnalysesResponse,
  CreateForecastExportJobResponse,
  ForecastExportJobSummary,
  ListExplainabilitiesResponse,
  GetAccuracyMetricsResponse,
  CreateWhatIfForecastExportResponse,
  DeletePredictorResponse,
  DescribeExplainabilityExportResponse,
  ExplainabilitySummary,
  MonitorSummary,
  CreateExplainabilityExportResponse,
  DescribeDatasetImportJobResponse,
  DeleteDatasetResponse,
  DescribeMonitorResponse,
  DeleteForecastExportJobResponse,
  DatasetImportJobSummary,
  DeleteExplainabilityExportResponse,
  ListWhatIfForecastExportsResponse,
  CreatePredictorBacktestExportJobResponse,
  DeleteWhatIfForecastExportResponse,
  DescribeExplainabilityResponse,
  ListDatasetsResponse,
  CreateAutoPredictorResponse,
  DescribePredictorBacktestExportJobResponse,
  ListForecastExportJobsResponse,
  CreateWhatIfForecastResponse,
  StopResourceResponse,
  ForecastSummary,
  WhatIfForecastExportSummary,
  CreatePredictorResponse,
  TagResourceResponse,
  DeleteDatasetImportJobResponse,
  CreateForecastResponse,
  ListWhatIfForecastsResponse,
  DescribeForecastExportJobResponse,
  DescribeWhatIfForecastResponse,
  CreateMonitorResponse,
  CreateDatasetGroupResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.forecast.{
  ForecastAsyncClientBuilder,
  ForecastAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Forecast extends AspectSupport[Forecast] {
  val api: ForecastAsyncClient
  def describeMonitor(
      request: DescribeMonitorRequest
  ): IO[AwsError, zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly]
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateDatasetResponse.ReadOnly]
  def listMonitors(
      request: ListMonitorsRequest
  ): ZStream[Any, AwsError, zio.aws.forecast.model.MonitorSummary.ReadOnly]
  def listMonitorsPaginated(
      request: ListMonitorsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListMonitorsResponse.ReadOnly]
  def describeWhatIfForecast(request: DescribeWhatIfForecastRequest): IO[
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly
  ]
  def deleteWhatIfForecastExport(
      request: DeleteWhatIfForecastExportRequest
  ): IO[AwsError, Unit]
  def createDatasetGroup(
      request: CreateDatasetGroupRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly]
  def listWhatIfForecastExports(
      request: ListWhatIfForecastExportsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly
  ]
  def listWhatIfForecastExportsPaginated(
      request: ListWhatIfForecastExportsRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly
  ]
  def createWhatIfForecast(
      request: CreateWhatIfForecastRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly]
  def createExplainability(
      request: CreateExplainabilityRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly]
  def createPredictor(
      request: CreatePredictorRequest
  ): IO[AwsError, zio.aws.forecast.model.CreatePredictorResponse.ReadOnly]
  def deleteMonitor(request: DeleteMonitorRequest): IO[AwsError, Unit]
  def deleteForecastExportJob(
      request: DeleteForecastExportJobRequest
  ): IO[AwsError, Unit]
  def describeDatasetImportJob(request: DescribeDatasetImportJobRequest): IO[
    AwsError,
    zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly
  ]
  def listPredictorBacktestExportJobs(
      request: ListPredictorBacktestExportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
  ]
  def listPredictorBacktestExportJobsPaginated(
      request: ListPredictorBacktestExportJobsRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly
  ]
  def createExplainabilityExport(
      request: CreateExplainabilityExportRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly
  ]
  def describeExplainabilityExport(
      request: DescribeExplainabilityExportRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly
  ]
  def describeDataset(
      request: DescribeDatasetRequest
  ): IO[AwsError, zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly]
  def createDatasetImportJob(request: CreateDatasetImportJobRequest): IO[
    AwsError,
    zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly
  ]
  def deleteForecast(request: DeleteForecastRequest): IO[AwsError, Unit]
  def createWhatIfAnalysis(
      request: CreateWhatIfAnalysisRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly]
  def listExplainabilities(request: ListExplainabilitiesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
  ]
  def listExplainabilitiesPaginated(
      request: ListExplainabilitiesRequest
  ): IO[AwsError, zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly]
  def deleteResourceTree(request: DeleteResourceTreeRequest): IO[AwsError, Unit]
  def createMonitor(
      request: CreateMonitorRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateMonitorResponse.ReadOnly]
  def describeWhatIfForecastExport(
      request: DescribeWhatIfForecastExportRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly
  ]
  def createAutoPredictor(
      request: CreateAutoPredictorRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly]
  def describeForecastExportJob(request: DescribeForecastExportJobRequest): IO[
    AwsError,
    zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly
  ]
  def deleteDatasetGroup(request: DeleteDatasetGroupRequest): IO[AwsError, Unit]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.forecast.model.UntagResourceResponse.ReadOnly]
  def describeExplainability(request: DescribeExplainabilityRequest): IO[
    AwsError,
    zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly
  ]
  def createWhatIfForecastExport(
      request: CreateWhatIfForecastExportRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly
  ]
  def listForecastExportJobs(request: ListForecastExportJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
  ]
  def listForecastExportJobsPaginated(
      request: ListForecastExportJobsRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly
  ]
  def deleteExplainability(
      request: DeleteExplainabilityRequest
  ): IO[AwsError, Unit]
  def listExplainabilityExports(
      request: ListExplainabilityExportsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
  ]
  def listExplainabilityExportsPaginated(
      request: ListExplainabilityExportsRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly
  ]
  def listDatasetGroups(
      request: ListDatasetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.forecast.model.DatasetGroupSummary.ReadOnly]
  def listDatasetGroupsPaginated(
      request: ListDatasetGroupsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly]
  def deleteDatasetImportJob(
      request: DeleteDatasetImportJobRequest
  ): IO[AwsError, Unit]
  def stopResource(request: StopResourceRequest): IO[AwsError, Unit]
  def describePredictorBacktestExportJob(
      request: DescribePredictorBacktestExportJobRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly
  ]
  def describeDatasetGroup(
      request: DescribeDatasetGroupRequest
  ): IO[AwsError, zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly]
  def createForecast(
      request: CreateForecastRequest
  ): IO[AwsError, zio.aws.forecast.model.CreateForecastResponse.ReadOnly]
  def deleteWhatIfAnalysis(
      request: DeleteWhatIfAnalysisRequest
  ): IO[AwsError, Unit]
  def listForecasts(
      request: ListForecastsRequest
  ): ZStream[Any, AwsError, zio.aws.forecast.model.ForecastSummary.ReadOnly]
  def listForecastsPaginated(
      request: ListForecastsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListForecastsResponse.ReadOnly]
  def listPredictors(
      request: ListPredictorsRequest
  ): ZStream[Any, AwsError, zio.aws.forecast.model.PredictorSummary.ReadOnly]
  def listPredictorsPaginated(
      request: ListPredictorsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListPredictorsResponse.ReadOnly]
  def resumeResource(request: ResumeResourceRequest): IO[AwsError, Unit]
  def deletePredictorBacktestExportJob(
      request: DeletePredictorBacktestExportJobRequest
  ): IO[AwsError, Unit]
  def createForecastExportJob(request: CreateForecastExportJobRequest): IO[
    AwsError,
    zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly
  ]
  def listDatasets(
      request: ListDatasetsRequest
  ): ZStream[Any, AwsError, zio.aws.forecast.model.DatasetSummary.ReadOnly]
  def listDatasetsPaginated(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListDatasetsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.forecast.model.ListTagsForResourceResponse.ReadOnly]
  def deleteExplainabilityExport(
      request: DeleteExplainabilityExportRequest
  ): IO[AwsError, Unit]
  def deletePredictor(request: DeletePredictorRequest): IO[AwsError, Unit]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.forecast.model.TagResourceResponse.ReadOnly]
  def listDatasetImportJobs(request: ListDatasetImportJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly
  ]
  def listDatasetImportJobsPaginated(
      request: ListDatasetImportJobsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListDatasetImportJobsResponse.ReadOnly]
  def describeAutoPredictor(
      request: DescribeAutoPredictorRequest
  ): IO[AwsError, zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly]
  def deleteWhatIfForecast(
      request: DeleteWhatIfForecastRequest
  ): IO[AwsError, Unit]
  def describeForecast(
      request: DescribeForecastRequest
  ): IO[AwsError, zio.aws.forecast.model.DescribeForecastResponse.ReadOnly]
  def listMonitorEvaluations(request: ListMonitorEvaluationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
  ]
  def listMonitorEvaluationsPaginated(
      request: ListMonitorEvaluationsRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly
  ]
  def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit]
  def createPredictorBacktestExportJob(
      request: CreatePredictorBacktestExportJobRequest
  ): IO[
    AwsError,
    zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly
  ]
  def listWhatIfForecasts(request: ListWhatIfForecastsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly
  ]
  def listWhatIfForecastsPaginated(
      request: ListWhatIfForecastsRequest
  ): IO[AwsError, zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly]
  def describeWhatIfAnalysis(request: DescribeWhatIfAnalysisRequest): IO[
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly
  ]
  def updateDatasetGroup(
      request: UpdateDatasetGroupRequest
  ): IO[AwsError, zio.aws.forecast.model.UpdateDatasetGroupResponse.ReadOnly]
  def listWhatIfAnalyses(request: ListWhatIfAnalysesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly
  ]
  def listWhatIfAnalysesPaginated(
      request: ListWhatIfAnalysesRequest
  ): IO[AwsError, zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly]
  def getAccuracyMetrics(
      request: GetAccuracyMetricsRequest
  ): IO[AwsError, zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly]
  def describePredictor(
      request: DescribePredictorRequest
  ): IO[AwsError, ReadOnly]
}
object Forecast {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Forecast] = customized(
    identity
  )
  def customized(
      customization: ForecastAsyncClientBuilder => ForecastAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Forecast] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ForecastAsyncClientBuilder => ForecastAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Forecast] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ForecastAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[ForecastAsyncClient, ForecastAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[ForecastAsyncClient, ForecastAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new ForecastImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ForecastImpl[R](
      override val api: ForecastAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Forecast
      with AwsServiceBase[R] {
    override val serviceName: String = "Forecast"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ForecastImpl[R1] = new ForecastImpl(api, newAspect, r)
    def describeMonitor(
        request: DescribeMonitorRequest
    ): IO[AwsError, zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest,
        DescribeMonitorResponse
      ]("describeMonitor", api.describeMonitor)(request.buildAwsValue())
        .map(zio.aws.forecast.model.DescribeMonitorResponse.wrap)
        .provideEnvironment(r)
    def createDataset(
        request: CreateDatasetRequest
    ): IO[AwsError, zio.aws.forecast.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.CreateDatasetRequest,
        CreateDatasetResponse
      ]("createDataset", api.createDataset)(request.buildAwsValue())
        .map(zio.aws.forecast.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def listMonitors(
        request: ListMonitorsRequest
    ): ZStream[Any, AwsError, zio.aws.forecast.model.MonitorSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.forecast.model.ListMonitorsRequest,
        ListMonitorsResponse,
        MonitorSummary
      ](
        "listMonitors",
        api.listMonitors,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.monitors().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.forecast.model.MonitorSummary.wrap(item))
        .provideEnvironment(r)
    def listMonitorsPaginated(
        request: ListMonitorsRequest
    ): IO[AwsError, zio.aws.forecast.model.ListMonitorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ListMonitorsRequest,
        ListMonitorsResponse
      ]("listMonitors", api.listMonitors)(request.buildAwsValue())
        .map(zio.aws.forecast.model.ListMonitorsResponse.wrap)
        .provideEnvironment(r)
    def describeWhatIfForecast(request: DescribeWhatIfForecastRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest,
      DescribeWhatIfForecastResponse
    ]("describeWhatIfForecast", api.describeWhatIfForecast)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeWhatIfForecastResponse.wrap)
      .provideEnvironment(r)
    def deleteWhatIfForecastExport(
        request: DeleteWhatIfForecastExportRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest,
      DeleteWhatIfForecastExportResponse
    ]("deleteWhatIfForecastExport", api.deleteWhatIfForecastExport)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDatasetGroup(request: CreateDatasetGroupRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest,
      CreateDatasetGroupResponse
    ]("createDatasetGroup", api.createDatasetGroup)(request.buildAwsValue())
      .map(zio.aws.forecast.model.CreateDatasetGroupResponse.wrap)
      .provideEnvironment(r)
    def listWhatIfForecastExports(
        request: ListWhatIfForecastExportsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsRequest,
      ListWhatIfForecastExportsResponse,
      WhatIfForecastExportSummary
    ](
      "listWhatIfForecastExports",
      api.listWhatIfForecastExports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.whatIfForecastExports().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.forecast.model.WhatIfForecastExportSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listWhatIfForecastExportsPaginated(
        request: ListWhatIfForecastExportsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListWhatIfForecastExportsRequest,
      ListWhatIfForecastExportsResponse
    ]("listWhatIfForecastExports", api.listWhatIfForecastExports)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListWhatIfForecastExportsResponse.wrap)
      .provideEnvironment(r)
    def createWhatIfForecast(request: CreateWhatIfForecastRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest,
      CreateWhatIfForecastResponse
    ]("createWhatIfForecast", api.createWhatIfForecast)(request.buildAwsValue())
      .map(zio.aws.forecast.model.CreateWhatIfForecastResponse.wrap)
      .provideEnvironment(r)
    def createExplainability(request: CreateExplainabilityRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateExplainabilityRequest,
      CreateExplainabilityResponse
    ]("createExplainability", api.createExplainability)(request.buildAwsValue())
      .map(zio.aws.forecast.model.CreateExplainabilityResponse.wrap)
      .provideEnvironment(r)
    def createPredictor(
        request: CreatePredictorRequest
    ): IO[AwsError, zio.aws.forecast.model.CreatePredictorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.CreatePredictorRequest,
        CreatePredictorResponse
      ]("createPredictor", api.createPredictor)(request.buildAwsValue())
        .map(zio.aws.forecast.model.CreatePredictorResponse.wrap)
        .provideEnvironment(r)
    def deleteMonitor(request: DeleteMonitorRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DeleteMonitorRequest,
        DeleteMonitorResponse
      ]("deleteMonitor", api.deleteMonitor)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteForecastExportJob(
        request: DeleteForecastExportJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest,
      DeleteForecastExportJobResponse
    ]("deleteForecastExportJob", api.deleteForecastExportJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeDatasetImportJob(request: DescribeDatasetImportJobRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest,
      DescribeDatasetImportJobResponse
    ]("describeDatasetImportJob", api.describeDatasetImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeDatasetImportJobResponse.wrap)
      .provideEnvironment(r)
    def listPredictorBacktestExportJobs(
        request: ListPredictorBacktestExportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest,
      ListPredictorBacktestExportJobsResponse,
      PredictorBacktestExportJobSummary
    ](
      "listPredictorBacktestExportJobs",
      api.listPredictorBacktestExportJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.predictorBacktestExportJobs().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.forecast.model.PredictorBacktestExportJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listPredictorBacktestExportJobsPaginated(
        request: ListPredictorBacktestExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsRequest,
      ListPredictorBacktestExportJobsResponse
    ]("listPredictorBacktestExportJobs", api.listPredictorBacktestExportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.wrap)
      .provideEnvironment(r)
    def createExplainabilityExport(
        request: CreateExplainabilityExportRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest,
      CreateExplainabilityExportResponse
    ]("createExplainabilityExport", api.createExplainabilityExport)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.CreateExplainabilityExportResponse.wrap)
      .provideEnvironment(r)
    def describeExplainabilityExport(
        request: DescribeExplainabilityExportRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportRequest,
      DescribeExplainabilityExportResponse
    ]("describeExplainabilityExport", api.describeExplainabilityExport)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeExplainabilityExportResponse.wrap)
      .provideEnvironment(r)
    def describeDataset(
        request: DescribeDatasetRequest
    ): IO[AwsError, zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DescribeDatasetRequest,
        DescribeDatasetResponse
      ]("describeDataset", api.describeDataset)(request.buildAwsValue())
        .map(zio.aws.forecast.model.DescribeDatasetResponse.wrap)
        .provideEnvironment(r)
    def createDatasetImportJob(request: CreateDatasetImportJobRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateDatasetImportJobRequest,
      CreateDatasetImportJobResponse
    ]("createDatasetImportJob", api.createDatasetImportJob)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.CreateDatasetImportJobResponse.wrap)
      .provideEnvironment(r)
    def deleteForecast(request: DeleteForecastRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DeleteForecastRequest,
        DeleteForecastResponse
      ]("deleteForecast", api.deleteForecast)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createWhatIfAnalysis(request: CreateWhatIfAnalysisRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateWhatIfAnalysisRequest,
      CreateWhatIfAnalysisResponse
    ]("createWhatIfAnalysis", api.createWhatIfAnalysis)(request.buildAwsValue())
      .map(zio.aws.forecast.model.CreateWhatIfAnalysisResponse.wrap)
      .provideEnvironment(r)
    def listExplainabilities(request: ListExplainabilitiesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest,
      ListExplainabilitiesResponse,
      ExplainabilitySummary
    ](
      "listExplainabilities",
      api.listExplainabilities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.explainabilities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.ExplainabilitySummary.wrap(item))
      .provideEnvironment(r)
    def listExplainabilitiesPaginated(request: ListExplainabilitiesRequest): IO[
      AwsError,
      zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListExplainabilitiesRequest,
      ListExplainabilitiesResponse
    ]("listExplainabilities", api.listExplainabilities)(request.buildAwsValue())
      .map(zio.aws.forecast.model.ListExplainabilitiesResponse.wrap)
      .provideEnvironment(r)
    def deleteResourceTree(
        request: DeleteResourceTreeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest,
      DeleteResourceTreeResponse
    ]("deleteResourceTree", api.deleteResourceTree)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createMonitor(
        request: CreateMonitorRequest
    ): IO[AwsError, zio.aws.forecast.model.CreateMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.CreateMonitorRequest,
        CreateMonitorResponse
      ]("createMonitor", api.createMonitor)(request.buildAwsValue())
        .map(zio.aws.forecast.model.CreateMonitorResponse.wrap)
        .provideEnvironment(r)
    def describeWhatIfForecastExport(
        request: DescribeWhatIfForecastExportRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest,
      DescribeWhatIfForecastExportResponse
    ]("describeWhatIfForecastExport", api.describeWhatIfForecastExport)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.wrap)
      .provideEnvironment(r)
    def createAutoPredictor(request: CreateAutoPredictorRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateAutoPredictorRequest,
      CreateAutoPredictorResponse
    ]("createAutoPredictor", api.createAutoPredictor)(request.buildAwsValue())
      .map(zio.aws.forecast.model.CreateAutoPredictorResponse.wrap)
      .provideEnvironment(r)
    def describeForecastExportJob(
        request: DescribeForecastExportJobRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest,
      DescribeForecastExportJobResponse
    ]("describeForecastExportJob", api.describeForecastExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeForecastExportJobResponse.wrap)
      .provideEnvironment(r)
    def deleteDatasetGroup(
        request: DeleteDatasetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest,
      DeleteDatasetGroupResponse
    ]("deleteDatasetGroup", api.deleteDatasetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.forecast.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.forecast.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeExplainability(request: DescribeExplainabilityRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeExplainabilityRequest,
      DescribeExplainabilityResponse
    ]("describeExplainability", api.describeExplainability)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeExplainabilityResponse.wrap)
      .provideEnvironment(r)
    def createWhatIfForecastExport(
        request: CreateWhatIfForecastExportRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest,
      CreateWhatIfForecastExportResponse
    ]("createWhatIfForecastExport", api.createWhatIfForecastExport)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.CreateWhatIfForecastExportResponse.wrap)
      .provideEnvironment(r)
    def listForecastExportJobs(request: ListForecastExportJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest,
      ListForecastExportJobsResponse,
      ForecastExportJobSummary
    ](
      "listForecastExportJobs",
      api.listForecastExportJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.forecastExportJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.ForecastExportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listForecastExportJobsPaginated(
        request: ListForecastExportJobsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest,
      ListForecastExportJobsResponse
    ]("listForecastExportJobs", api.listForecastExportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListForecastExportJobsResponse.wrap)
      .provideEnvironment(r)
    def deleteExplainability(
        request: DeleteExplainabilityRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteExplainabilityRequest,
      DeleteExplainabilityResponse
    ]("deleteExplainability", api.deleteExplainability)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listExplainabilityExports(
        request: ListExplainabilityExportsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest,
      ListExplainabilityExportsResponse,
      ExplainabilityExportSummary
    ](
      "listExplainabilityExports",
      api.listExplainabilityExports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.explainabilityExports().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.forecast.model.ExplainabilityExportSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listExplainabilityExportsPaginated(
        request: ListExplainabilityExportsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListExplainabilityExportsRequest,
      ListExplainabilityExportsResponse
    ]("listExplainabilityExports", api.listExplainabilityExports)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListExplainabilityExportsResponse.wrap)
      .provideEnvironment(r)
    def listDatasetGroups(request: ListDatasetGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.DatasetGroupSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest,
      ListDatasetGroupsResponse,
      DatasetGroupSummary
    ](
      "listDatasetGroups",
      api.listDatasetGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.DatasetGroupSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetGroupsPaginated(
        request: ListDatasetGroupsRequest
    ): IO[AwsError, zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ListDatasetGroupsRequest,
        ListDatasetGroupsResponse
      ]("listDatasetGroups", api.listDatasetGroups)(request.buildAwsValue())
        .map(zio.aws.forecast.model.ListDatasetGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteDatasetImportJob(
        request: DeleteDatasetImportJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteDatasetImportJobRequest,
      DeleteDatasetImportJobResponse
    ]("deleteDatasetImportJob", api.deleteDatasetImportJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def stopResource(request: StopResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.StopResourceRequest,
        StopResourceResponse
      ]("stopResource", api.stopResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describePredictorBacktestExportJob(
        request: DescribePredictorBacktestExportJobRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest,
      DescribePredictorBacktestExportJobResponse
    ](
      "describePredictorBacktestExportJob",
      api.describePredictorBacktestExportJob
    )(request.buildAwsValue())
      .map(
        zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.wrap
      )
      .provideEnvironment(r)
    def describeDatasetGroup(request: DescribeDatasetGroupRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest,
      DescribeDatasetGroupResponse
    ]("describeDatasetGroup", api.describeDatasetGroup)(request.buildAwsValue())
      .map(zio.aws.forecast.model.DescribeDatasetGroupResponse.wrap)
      .provideEnvironment(r)
    def createForecast(
        request: CreateForecastRequest
    ): IO[AwsError, zio.aws.forecast.model.CreateForecastResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.CreateForecastRequest,
        CreateForecastResponse
      ]("createForecast", api.createForecast)(request.buildAwsValue())
        .map(zio.aws.forecast.model.CreateForecastResponse.wrap)
        .provideEnvironment(r)
    def deleteWhatIfAnalysis(
        request: DeleteWhatIfAnalysisRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteWhatIfAnalysisRequest,
      DeleteWhatIfAnalysisResponse
    ]("deleteWhatIfAnalysis", api.deleteWhatIfAnalysis)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listForecasts(
        request: ListForecastsRequest
    ): ZStream[Any, AwsError, zio.aws.forecast.model.ForecastSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.forecast.model.ListForecastsRequest,
        ListForecastsResponse,
        ForecastSummary
      ](
        "listForecasts",
        api.listForecasts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.forecasts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.forecast.model.ForecastSummary.wrap(item))
        .provideEnvironment(r)
    def listForecastsPaginated(
        request: ListForecastsRequest
    ): IO[AwsError, zio.aws.forecast.model.ListForecastsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ListForecastsRequest,
        ListForecastsResponse
      ]("listForecasts", api.listForecasts)(request.buildAwsValue())
        .map(zio.aws.forecast.model.ListForecastsResponse.wrap)
        .provideEnvironment(r)
    def listPredictors(request: ListPredictorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.PredictorSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListPredictorsRequest,
      ListPredictorsResponse,
      PredictorSummary
    ](
      "listPredictors",
      api.listPredictors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.predictors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.PredictorSummary.wrap(item))
      .provideEnvironment(r)
    def listPredictorsPaginated(
        request: ListPredictorsRequest
    ): IO[AwsError, zio.aws.forecast.model.ListPredictorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ListPredictorsRequest,
        ListPredictorsResponse
      ]("listPredictors", api.listPredictors)(request.buildAwsValue())
        .map(zio.aws.forecast.model.ListPredictorsResponse.wrap)
        .provideEnvironment(r)
    def resumeResource(request: ResumeResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ResumeResourceRequest,
        ResumeResourceResponse
      ]("resumeResource", api.resumeResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deletePredictorBacktestExportJob(
        request: DeletePredictorBacktestExportJobRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeletePredictorBacktestExportJobRequest,
      DeletePredictorBacktestExportJobResponse
    ]("deletePredictorBacktestExportJob", api.deletePredictorBacktestExportJob)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createForecastExportJob(request: CreateForecastExportJobRequest): IO[
      AwsError,
      zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest,
      CreateForecastExportJobResponse
    ]("createForecastExportJob", api.createForecastExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.CreateForecastExportJobResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: ListDatasetsRequest
    ): ZStream[Any, AwsError, zio.aws.forecast.model.DatasetSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.forecast.model.ListDatasetsRequest,
        ListDatasetsResponse,
        DatasetSummary
      ](
        "listDatasets",
        api.listDatasets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.datasets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.forecast.model.DatasetSummary.wrap(item))
        .provideEnvironment(r)
    def listDatasetsPaginated(
        request: ListDatasetsRequest
    ): IO[AwsError, zio.aws.forecast.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.ListDatasetsRequest,
        ListDatasetsResponse
      ]("listDatasets", api.listDatasets)(request.buildAwsValue())
        .map(zio.aws.forecast.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.forecast.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.forecast.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteExplainabilityExport(
        request: DeleteExplainabilityExportRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest,
      DeleteExplainabilityExportResponse
    ]("deleteExplainabilityExport", api.deleteExplainabilityExport)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deletePredictor(request: DeletePredictorRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DeletePredictorRequest,
        DeletePredictorResponse
      ]("deletePredictor", api.deletePredictor)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.forecast.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.forecast.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listDatasetImportJobs(request: ListDatasetImportJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest,
      ListDatasetImportJobsResponse,
      DatasetImportJobSummary
    ](
      "listDatasetImportJobs",
      api.listDatasetImportJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.datasetImportJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.DatasetImportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listDatasetImportJobsPaginated(
        request: ListDatasetImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListDatasetImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListDatasetImportJobsRequest,
      ListDatasetImportJobsResponse
    ]("listDatasetImportJobs", api.listDatasetImportJobs)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListDatasetImportJobsResponse.wrap)
      .provideEnvironment(r)
    def describeAutoPredictor(request: DescribeAutoPredictorRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorRequest,
      DescribeAutoPredictorResponse
    ]("describeAutoPredictor", api.describeAutoPredictor)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeAutoPredictorResponse.wrap)
      .provideEnvironment(r)
    def deleteWhatIfForecast(
        request: DeleteWhatIfForecastRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest,
      DeleteWhatIfForecastResponse
    ]("deleteWhatIfForecast", api.deleteWhatIfForecast)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeForecast(
        request: DescribeForecastRequest
    ): IO[AwsError, zio.aws.forecast.model.DescribeForecastResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DescribeForecastRequest,
        DescribeForecastResponse
      ]("describeForecast", api.describeForecast)(request.buildAwsValue())
        .map(zio.aws.forecast.model.DescribeForecastResponse.wrap)
        .provideEnvironment(r)
    def listMonitorEvaluations(request: ListMonitorEvaluationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest,
      ListMonitorEvaluationsResponse,
      PredictorMonitorEvaluation
    ](
      "listMonitorEvaluations",
      api.listMonitorEvaluations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.predictorMonitorEvaluations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.PredictorMonitorEvaluation.wrap(item))
      .provideEnvironment(r)
    def listMonitorEvaluationsPaginated(
        request: ListMonitorEvaluationsRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsRequest,
      ListMonitorEvaluationsResponse
    ]("listMonitorEvaluations", api.listMonitorEvaluations)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.ListMonitorEvaluationsResponse.wrap)
      .provideEnvironment(r)
    def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createPredictorBacktestExportJob(
        request: CreatePredictorBacktestExportJobRequest
    ): IO[
      AwsError,
      zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest,
      CreatePredictorBacktestExportJobResponse
    ]("createPredictorBacktestExportJob", api.createPredictorBacktestExportJob)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.wrap)
      .provideEnvironment(r)
    def listWhatIfForecasts(request: ListWhatIfForecastsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsRequest,
      ListWhatIfForecastsResponse,
      WhatIfForecastSummary
    ](
      "listWhatIfForecasts",
      api.listWhatIfForecasts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.whatIfForecasts().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.WhatIfForecastSummary.wrap(item))
      .provideEnvironment(r)
    def listWhatIfForecastsPaginated(request: ListWhatIfForecastsRequest): IO[
      AwsError,
      zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsRequest,
      ListWhatIfForecastsResponse
    ]("listWhatIfForecasts", api.listWhatIfForecasts)(request.buildAwsValue())
      .map(zio.aws.forecast.model.ListWhatIfForecastsResponse.wrap)
      .provideEnvironment(r)
    def describeWhatIfAnalysis(request: DescribeWhatIfAnalysisRequest): IO[
      AwsError,
      zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisRequest,
      DescribeWhatIfAnalysisResponse
    ]("describeWhatIfAnalysis", api.describeWhatIfAnalysis)(
      request.buildAwsValue()
    ).map(zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.wrap)
      .provideEnvironment(r)
    def updateDatasetGroup(request: UpdateDatasetGroupRequest): IO[
      AwsError,
      zio.aws.forecast.model.UpdateDatasetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.UpdateDatasetGroupRequest,
      UpdateDatasetGroupResponse
    ]("updateDatasetGroup", api.updateDatasetGroup)(request.buildAwsValue())
      .map(zio.aws.forecast.model.UpdateDatasetGroupResponse.wrap)
      .provideEnvironment(r)
    def listWhatIfAnalyses(request: ListWhatIfAnalysesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesRequest,
      ListWhatIfAnalysesResponse,
      WhatIfAnalysisSummary
    ](
      "listWhatIfAnalyses",
      api.listWhatIfAnalyses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.whatIfAnalyses().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.forecast.model.WhatIfAnalysisSummary.wrap(item))
      .provideEnvironment(r)
    def listWhatIfAnalysesPaginated(request: ListWhatIfAnalysesRequest): IO[
      AwsError,
      zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesRequest,
      ListWhatIfAnalysesResponse
    ]("listWhatIfAnalyses", api.listWhatIfAnalyses)(request.buildAwsValue())
      .map(zio.aws.forecast.model.ListWhatIfAnalysesResponse.wrap)
      .provideEnvironment(r)
    def getAccuracyMetrics(request: GetAccuracyMetricsRequest): IO[
      AwsError,
      zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest,
      GetAccuracyMetricsResponse
    ]("getAccuracyMetrics", api.getAccuracyMetrics)(request.buildAwsValue())
      .map(zio.aws.forecast.model.GetAccuracyMetricsResponse.wrap)
      .provideEnvironment(r)
    def describePredictor(
        request: DescribePredictorRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.forecast.model.DescribePredictorRequest,
      DescribePredictorResponse
    ]("describePredictor", api.describePredictor)(request.buildAwsValue())
      .map(zio.aws.forecast.model.DescribePredictorResponse.wrap)
      .provideEnvironment(r)
  }
  def describeMonitor(request: DescribeMonitorRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMonitor(request))
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listMonitors(request: ListMonitorsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.MonitorSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitors(request))
  def listMonitorsPaginated(request: ListMonitorsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListMonitorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitorsPaginated(request))
  def describeWhatIfForecast(request: DescribeWhatIfForecastRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWhatIfForecast(request))
  def deleteWhatIfForecastExport(
      request: DeleteWhatIfForecastExportRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWhatIfForecastExport(request))
  def createDatasetGroup(request: CreateDatasetGroupRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateDatasetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetGroup(request))
  def listWhatIfForecastExports(
      request: ListWhatIfForecastExportsRequest
  ): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.WhatIfForecastExportSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWhatIfForecastExports(request))
  def listWhatIfForecastExportsPaginated(
      request: ListWhatIfForecastExportsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListWhatIfForecastExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWhatIfForecastExportsPaginated(request))
  def createWhatIfForecast(request: CreateWhatIfForecastRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWhatIfForecast(request))
  def createExplainability(request: CreateExplainabilityRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateExplainabilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExplainability(request))
  def createPredictor(request: CreatePredictorRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreatePredictorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPredictor(request))
  def deleteMonitor(
      request: DeleteMonitorRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteMonitor(request))
  def deleteForecastExportJob(
      request: DeleteForecastExportJobRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteForecastExportJob(request))
  def describeDatasetImportJob(request: DescribeDatasetImportJobRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatasetImportJob(request))
  def listPredictorBacktestExportJobs(
      request: ListPredictorBacktestExportJobsRequest
  ): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPredictorBacktestExportJobs(request))
  def listPredictorBacktestExportJobsPaginated(
      request: ListPredictorBacktestExportJobsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPredictorBacktestExportJobsPaginated(request))
  def createExplainabilityExport(
      request: CreateExplainabilityExportRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateExplainabilityExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createExplainabilityExport(request))
  def describeExplainabilityExport(
      request: DescribeExplainabilityExportRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExplainabilityExport(request))
  def describeDataset(request: DescribeDatasetRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDataset(request))
  def createDatasetImportJob(request: CreateDatasetImportJobRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateDatasetImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDatasetImportJob(request))
  def deleteForecast(
      request: DeleteForecastRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteForecast(request))
  def createWhatIfAnalysis(request: CreateWhatIfAnalysisRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateWhatIfAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWhatIfAnalysis(request))
  def listExplainabilities(request: ListExplainabilitiesRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ExplainabilitySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExplainabilities(request))
  def listExplainabilitiesPaginated(request: ListExplainabilitiesRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListExplainabilitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExplainabilitiesPaginated(request))
  def deleteResourceTree(
      request: DeleteResourceTreeRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteResourceTree(request))
  def createMonitor(request: CreateMonitorRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMonitor(request))
  def describeWhatIfForecastExport(
      request: DescribeWhatIfForecastExportRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfForecastExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWhatIfForecastExport(request))
  def createAutoPredictor(request: CreateAutoPredictorRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAutoPredictor(request))
  def describeForecastExportJob(request: DescribeForecastExportJobRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeForecastExportJob(request))
  def deleteDatasetGroup(
      request: DeleteDatasetGroupRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatasetGroup(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeExplainability(request: DescribeExplainabilityRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExplainability(request))
  def createWhatIfForecastExport(
      request: CreateWhatIfForecastExportRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateWhatIfForecastExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWhatIfForecastExport(request))
  def listForecastExportJobs(request: ListForecastExportJobsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listForecastExportJobs(request))
  def listForecastExportJobsPaginated(
      request: ListForecastExportJobsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listForecastExportJobsPaginated(request))
  def deleteExplainability(
      request: DeleteExplainabilityRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteExplainability(request))
  def listExplainabilityExports(
      request: ListExplainabilityExportsRequest
  ): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ExplainabilityExportSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listExplainabilityExports(request))
  def listExplainabilityExportsPaginated(
      request: ListExplainabilityExportsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListExplainabilityExportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExplainabilityExportsPaginated(request))
  def listDatasetGroups(request: ListDatasetGroupsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DatasetGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetGroups(request))
  def listDatasetGroupsPaginated(request: ListDatasetGroupsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetGroupsPaginated(request))
  def deleteDatasetImportJob(
      request: DeleteDatasetImportJobRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDatasetImportJob(request))
  def stopResource(
      request: StopResourceRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopResource(request))
  def describePredictorBacktestExportJob(
      request: DescribePredictorBacktestExportJobRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribePredictorBacktestExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePredictorBacktestExportJob(request))
  def describeDatasetGroup(request: DescribeDatasetGroupRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeDatasetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDatasetGroup(request))
  def createForecast(request: CreateForecastRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateForecastResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createForecast(request))
  def deleteWhatIfAnalysis(
      request: DeleteWhatIfAnalysisRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWhatIfAnalysis(request))
  def listForecasts(request: ListForecastsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ForecastSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listForecasts(request))
  def listForecastsPaginated(request: ListForecastsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListForecastsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listForecastsPaginated(request))
  def listPredictors(request: ListPredictorsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.PredictorSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPredictors(request))
  def listPredictorsPaginated(request: ListPredictorsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListPredictorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPredictorsPaginated(request))
  def resumeResource(
      request: ResumeResourceRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resumeResource(request))
  def deletePredictorBacktestExportJob(
      request: DeletePredictorBacktestExportJobRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePredictorBacktestExportJob(request))
  def createForecastExportJob(request: CreateForecastExportJobRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreateForecastExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createForecastExportJob(request))
  def listDatasets(request: ListDatasetsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DatasetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(request: ListDatasetsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteExplainabilityExport(
      request: DeleteExplainabilityExportRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteExplainabilityExport(request))
  def deletePredictor(
      request: DeletePredictorRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePredictor(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listDatasetImportJobs(request: ListDatasetImportJobsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasetImportJobs(request))
  def listDatasetImportJobsPaginated(
      request: ListDatasetImportJobsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListDatasetImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetImportJobsPaginated(request))
  def describeAutoPredictor(request: DescribeAutoPredictorRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAutoPredictor(request))
  def deleteWhatIfForecast(
      request: DeleteWhatIfForecastRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWhatIfForecast(request))
  def describeForecast(request: DescribeForecastRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeForecastResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeForecast(request))
  def listMonitorEvaluations(request: ListMonitorEvaluationsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitorEvaluations(request))
  def listMonitorEvaluationsPaginated(
      request: ListMonitorEvaluationsRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitorEvaluationsPaginated(request))
  def deleteDataset(
      request: DeleteDatasetRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDataset(request))
  def createPredictorBacktestExportJob(
      request: CreatePredictorBacktestExportJobRequest
  ): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.CreatePredictorBacktestExportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPredictorBacktestExportJob(request))
  def listWhatIfForecasts(request: ListWhatIfForecastsRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWhatIfForecasts(request))
  def listWhatIfForecastsPaginated(request: ListWhatIfForecastsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWhatIfForecastsPaginated(request))
  def describeWhatIfAnalysis(request: DescribeWhatIfAnalysisRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWhatIfAnalysis(request))
  def updateDatasetGroup(request: UpdateDatasetGroupRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.UpdateDatasetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDatasetGroup(request))
  def listWhatIfAnalyses(request: ListWhatIfAnalysesRequest): ZStream[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWhatIfAnalyses(request))
  def listWhatIfAnalysesPaginated(request: ListWhatIfAnalysesRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWhatIfAnalysesPaginated(request))
  def getAccuracyMetrics(request: GetAccuracyMetricsRequest): ZIO[
    zio.aws.forecast.Forecast,
    AwsError,
    zio.aws.forecast.model.GetAccuracyMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccuracyMetrics(request))
  def describePredictor(
      request: DescribePredictorRequest
  ): ZIO[zio.aws.forecast.Forecast, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describePredictor(request))
}
