package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Baseline(
    predictorBaseline: Optional[zio.aws.forecast.model.PredictorBaseline] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.Baseline = {
    import Baseline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Baseline
      .builder()
      .optionallyWith(predictorBaseline.map(value => value.buildAwsValue()))(
        _.predictorBaseline
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Baseline.ReadOnly =
    zio.aws.forecast.model.Baseline.wrap(buildAwsValue())
}
object Baseline {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.Baseline] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Baseline = zio.aws.forecast.model
      .Baseline(predictorBaseline.map(value => value.asEditable))
    def predictorBaseline
        : Optional[zio.aws.forecast.model.PredictorBaseline.ReadOnly]
    def getPredictorBaseline: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.PredictorBaseline.ReadOnly
    ] = AwsError.unwrapOptionField("predictorBaseline", predictorBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Baseline
  ) extends zio.aws.forecast.model.Baseline.ReadOnly {
    override val predictorBaseline
        : Optional[zio.aws.forecast.model.PredictorBaseline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorBaseline())
        .map(value => zio.aws.forecast.model.PredictorBaseline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Baseline
  ): zio.aws.forecast.model.Baseline.ReadOnly = new Wrapper(impl)
}
