package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Value, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CategoricalParameterRange(
    name: Name,
    values: Iterable[Value]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CategoricalParameterRange = {
    import CategoricalParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CategoricalParameterRange
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .values(values.map { item =>
        Value.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CategoricalParameterRange.ReadOnly =
    zio.aws.forecast.model.CategoricalParameterRange.wrap(buildAwsValue())
}
object CategoricalParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CategoricalParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CategoricalParameterRange =
      zio.aws.forecast.model.CategoricalParameterRange(name, values)
    def name: Name
    def values: List[Value]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[Value]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CategoricalParameterRange
  ) extends zio.aws.forecast.model.CategoricalParameterRange.ReadOnly {
    override val name: Name =
      zio.aws.forecast.model.primitives.Name(impl.name())
    override val values: List[Value] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.forecast.model.primitives.Value(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CategoricalParameterRange
  ): zio.aws.forecast.model.CategoricalParameterRange.ReadOnly = new Wrapper(
    impl
  )
}
