package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMonitorRequest(
    monitorName: Name,
    resourceArn: Arn,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateMonitorRequest = {
    import CreateMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateMonitorRequest
      .builder()
      .monitorName(Name.unwrap(monitorName): java.lang.String)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateMonitorRequest.ReadOnly =
    zio.aws.forecast.model.CreateMonitorRequest.wrap(buildAwsValue())
}
object CreateMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateMonitorRequest =
      zio.aws.forecast.model.CreateMonitorRequest(
        monitorName,
        resourceArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitorName: Name
    def resourceArn: Arn
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getMonitorName: ZIO[Any, Nothing, Name] = ZIO.succeed(monitorName)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateMonitorRequest
  ) extends zio.aws.forecast.model.CreateMonitorRequest.ReadOnly {
    override val monitorName: Name =
      zio.aws.forecast.model.primitives.Name(impl.monitorName())
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateMonitorRequest
  ): zio.aws.forecast.model.CreateMonitorRequest.ReadOnly = new Wrapper(impl)
}
