package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateMonitorResponse(
    monitorArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateMonitorResponse = {
    import CreateMonitorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateMonitorResponse
      .builder()
      .optionallyWith(
        monitorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.monitorArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateMonitorResponse.ReadOnly =
    zio.aws.forecast.model.CreateMonitorResponse.wrap(buildAwsValue())
}
object CreateMonitorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateMonitorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateMonitorResponse =
      zio.aws.forecast.model
        .CreateMonitorResponse(monitorArn.map(value => value))
    def monitorArn: Optional[Arn]
    def getMonitorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("monitorArn", monitorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateMonitorResponse
  ) extends zio.aws.forecast.model.CreateMonitorResponse.ReadOnly {
    override val monitorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateMonitorResponse
  ): zio.aws.forecast.model.CreateMonitorResponse.ReadOnly = new Wrapper(impl)
}
