package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Format, Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePredictorBacktestExportJobRequest(
    predictorBacktestExportJobName: Name,
    predictorArn: Arn,
    destination: zio.aws.forecast.model.DataDestination,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest = {
    import CreatePredictorBacktestExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest
      .builder()
      .predictorBacktestExportJobName(
        Name.unwrap(predictorBacktestExportJobName): java.lang.String
      )
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest.ReadOnly =
    zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest
      .wrap(buildAwsValue())
}
object CreatePredictorBacktestExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest =
      zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest(
        predictorBacktestExportJobName,
        predictorArn,
        destination.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        format.map(value => value)
      )
    def predictorBacktestExportJobName: Name
    def predictorArn: Arn
    def destination: zio.aws.forecast.model.DataDestination.ReadOnly
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def format: Optional[Format]
    def getPredictorBacktestExportJobName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(predictorBacktestExportJobName)
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.forecast.model.DataDestination.ReadOnly] =
      ZIO.succeed(destination)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest
  ) extends zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest.ReadOnly {
    override val predictorBacktestExportJobName: Name =
      zio.aws.forecast.model.primitives
        .Name(impl.predictorBacktestExportJobName())
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
    override val destination: zio.aws.forecast.model.DataDestination.ReadOnly =
      zio.aws.forecast.model.DataDestination.wrap(impl.destination())
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreatePredictorBacktestExportJobRequest
  ): zio.aws.forecast.model.CreatePredictorBacktestExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
