package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Format, LongArn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWhatIfForecastExportRequest(
    whatIfForecastExportName: Name,
    whatIfForecastArns: Iterable[LongArn],
    destination: zio.aws.forecast.model.DataDestination,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest = {
    import CreateWhatIfForecastExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest
      .builder()
      .whatIfForecastExportName(
        Name.unwrap(whatIfForecastExportName): java.lang.String
      )
      .whatIfForecastArns(whatIfForecastArns.map { item =>
        LongArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateWhatIfForecastExportRequest.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfForecastExportRequest
      .wrap(buildAwsValue())
}
object CreateWhatIfForecastExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfForecastExportRequest =
      zio.aws.forecast.model.CreateWhatIfForecastExportRequest(
        whatIfForecastExportName,
        whatIfForecastArns,
        destination.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        format.map(value => value)
      )
    def whatIfForecastExportName: Name
    def whatIfForecastArns: List[LongArn]
    def destination: zio.aws.forecast.model.DataDestination.ReadOnly
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def format: Optional[Format]
    def getWhatIfForecastExportName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(whatIfForecastExportName)
    def getWhatIfForecastArns: ZIO[Any, Nothing, List[LongArn]] =
      ZIO.succeed(whatIfForecastArns)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.forecast.model.DataDestination.ReadOnly] =
      ZIO.succeed(destination)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest
  ) extends zio.aws.forecast.model.CreateWhatIfForecastExportRequest.ReadOnly {
    override val whatIfForecastExportName: Name =
      zio.aws.forecast.model.primitives.Name(impl.whatIfForecastExportName())
    override val whatIfForecastArns: List[LongArn] = impl
      .whatIfForecastArns()
      .asScala
      .map { item =>
        zio.aws.forecast.model.primitives.LongArn(item)
      }
      .toList
    override val destination: zio.aws.forecast.model.DataDestination.ReadOnly =
      zio.aws.forecast.model.DataDestination.wrap(impl.destination())
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastExportRequest
  ): zio.aws.forecast.model.CreateWhatIfForecastExportRequest.ReadOnly =
    new Wrapper(impl)
}
