package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWhatIfForecastRequest(
    whatIfForecastName: Name,
    whatIfAnalysisArn: Arn,
    timeSeriesTransformations: Optional[
      Iterable[zio.aws.forecast.model.TimeSeriesTransformation]
    ] = Optional.Absent,
    timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest = {
    import CreateWhatIfForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest
      .builder()
      .whatIfForecastName(Name.unwrap(whatIfForecastName): java.lang.String)
      .whatIfAnalysisArn(Arn.unwrap(whatIfAnalysisArn): java.lang.String)
      .optionallyWith(
        timeSeriesTransformations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeSeriesTransformations)
      .optionallyWith(
        timeSeriesReplacementsDataSource.map(value => value.buildAwsValue())
      )(_.timeSeriesReplacementsDataSource)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateWhatIfForecastRequest.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfForecastRequest.wrap(buildAwsValue())
}
object CreateWhatIfForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfForecastRequest =
      zio.aws.forecast.model.CreateWhatIfForecastRequest(
        whatIfForecastName,
        whatIfAnalysisArn,
        timeSeriesTransformations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeSeriesReplacementsDataSource.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def whatIfForecastName: Name
    def whatIfAnalysisArn: Arn
    def timeSeriesTransformations: Optional[
      List[zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly]
    ]
    def timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getWhatIfForecastName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(whatIfForecastName)
    def getWhatIfAnalysisArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(whatIfAnalysisArn)
    def getTimeSeriesTransformations: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "timeSeriesTransformations",
      timeSeriesTransformations
    )
    def getTimeSeriesReplacementsDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesReplacementsDataSource",
      timeSeriesReplacementsDataSource
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest
  ) extends zio.aws.forecast.model.CreateWhatIfForecastRequest.ReadOnly {
    override val whatIfForecastName: Name =
      zio.aws.forecast.model.primitives.Name(impl.whatIfForecastName())
    override val whatIfAnalysisArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.whatIfAnalysisArn())
    override val timeSeriesTransformations: Optional[
      List[zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesTransformations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.TimeSeriesTransformation.wrap(item)
        }.toList
      )
    override val timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesReplacementsDataSource())
      .map(value =>
        zio.aws.forecast.model.TimeSeriesReplacementsDataSource.wrap(value)
      )
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastRequest
  ): zio.aws.forecast.model.CreateWhatIfForecastRequest.ReadOnly = new Wrapper(
    impl
  )
}
