package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWhatIfForecastResponse(
    whatIfForecastArn: Optional[LongArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse = {
    import CreateWhatIfForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse
      .builder()
      .optionallyWith(
        whatIfForecastArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.whatIfForecastArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly =
    zio.aws.forecast.model.CreateWhatIfForecastResponse.wrap(buildAwsValue())
}
object CreateWhatIfForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateWhatIfForecastResponse =
      zio.aws.forecast.model
        .CreateWhatIfForecastResponse(whatIfForecastArn.map(value => value))
    def whatIfForecastArn: Optional[LongArn]
    def getWhatIfForecastArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("whatIfForecastArn", whatIfForecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse
  ) extends zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly {
    override val whatIfForecastArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastArn())
      .map(value => zio.aws.forecast.model.primitives.LongArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateWhatIfForecastResponse
  ): zio.aws.forecast.model.CreateWhatIfForecastResponse.ReadOnly = new Wrapper(
    impl
  )
}
