package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DataSource(s3Config: zio.aws.forecast.model.S3Config) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DataSource
      .builder()
      .s3Config(s3Config.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DataSource.ReadOnly =
    zio.aws.forecast.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DataSource =
      zio.aws.forecast.model.DataSource(s3Config.asEditable)
    def s3Config: zio.aws.forecast.model.S3Config.ReadOnly
    def getS3Config
        : ZIO[Any, Nothing, zio.aws.forecast.model.S3Config.ReadOnly] =
      ZIO.succeed(s3Config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DataSource
  ) extends zio.aws.forecast.model.DataSource.ReadOnly {
    override val s3Config: zio.aws.forecast.model.S3Config.ReadOnly =
      zio.aws.forecast.model.S3Config.wrap(impl.s3Config())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DataSource
  ): zio.aws.forecast.model.DataSource.ReadOnly = new Wrapper(impl)
}
