package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetSummary(
    datasetArn: Optional[Arn] = Optional.Absent,
    datasetName: Optional[Name] = Optional.Absent,
    datasetType: Optional[zio.aws.forecast.model.DatasetType] = Optional.Absent,
    domain: Optional[zio.aws.forecast.model.Domain] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DatasetSummary = {
    import DatasetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DatasetSummary
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DatasetSummary.ReadOnly =
    zio.aws.forecast.model.DatasetSummary.wrap(buildAwsValue())
}
object DatasetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DatasetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DatasetSummary =
      zio.aws.forecast.model.DatasetSummary(
        datasetArn.map(value => value),
        datasetName.map(value => value),
        datasetType.map(value => value),
        domain.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetArn: Optional[Arn]
    def datasetName: Optional[Name]
    def datasetType: Optional[zio.aws.forecast.model.DatasetType]
    def domain: Optional[zio.aws.forecast.model.Domain]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetType: ZIO[Any, AwsError, zio.aws.forecast.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDomain: ZIO[Any, AwsError, zio.aws.forecast.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DatasetSummary
  ) extends zio.aws.forecast.model.DatasetSummary.ReadOnly {
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val datasetType: Optional[zio.aws.forecast.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.forecast.model.DatasetType.wrap(value))
    override val domain: Optional[zio.aws.forecast.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.forecast.model.Domain.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DatasetSummary
  ): zio.aws.forecast.model.DatasetSummary.ReadOnly = new Wrapper(impl)
}
