package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteForecastExportJobRequest(forecastExportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest = {
    import DeleteForecastExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest
      .builder()
      .forecastExportJobArn(Arn.unwrap(forecastExportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DeleteForecastExportJobRequest.ReadOnly =
    zio.aws.forecast.model.DeleteForecastExportJobRequest.wrap(buildAwsValue())
}
object DeleteForecastExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteForecastExportJobRequest =
      zio.aws.forecast.model
        .DeleteForecastExportJobRequest(forecastExportJobArn)
    def forecastExportJobArn: Arn
    def getForecastExportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(forecastExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest
  ) extends zio.aws.forecast.model.DeleteForecastExportJobRequest.ReadOnly {
    override val forecastExportJobArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteForecastExportJobRequest
  ): zio.aws.forecast.model.DeleteForecastExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
