package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteResourceTreeRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest = {
    import DeleteResourceTreeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteResourceTreeRequest.ReadOnly =
    zio.aws.forecast.model.DeleteResourceTreeRequest.wrap(buildAwsValue())
}
object DeleteResourceTreeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteResourceTreeRequest =
      zio.aws.forecast.model.DeleteResourceTreeRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest
  ) extends zio.aws.forecast.model.DeleteResourceTreeRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteResourceTreeRequest
  ): zio.aws.forecast.model.DeleteResourceTreeRequest.ReadOnly = new Wrapper(
    impl
  )
}
