package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteWhatIfForecastExportRequest(
    whatIfForecastExportArn: LongArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest = {
    import DeleteWhatIfForecastExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest
      .builder()
      .whatIfForecastExportArn(
        LongArn.unwrap(whatIfForecastExportArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DeleteWhatIfForecastExportRequest.ReadOnly =
    zio.aws.forecast.model.DeleteWhatIfForecastExportRequest
      .wrap(buildAwsValue())
}
object DeleteWhatIfForecastExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteWhatIfForecastExportRequest =
      zio.aws.forecast.model
        .DeleteWhatIfForecastExportRequest(whatIfForecastExportArn)
    def whatIfForecastExportArn: LongArn
    def getWhatIfForecastExportArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(whatIfForecastExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest
  ) extends zio.aws.forecast.model.DeleteWhatIfForecastExportRequest.ReadOnly {
    override val whatIfForecastExportArn: LongArn =
      zio.aws.forecast.model.primitives.LongArn(impl.whatIfForecastExportArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastExportRequest
  ): zio.aws.forecast.model.DeleteWhatIfForecastExportRequest.ReadOnly =
    new Wrapper(impl)
}
