package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteWhatIfForecastRequest(whatIfForecastArn: LongArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest = {
    import DeleteWhatIfForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest
      .builder()
      .whatIfForecastArn(LongArn.unwrap(whatIfForecastArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteWhatIfForecastRequest.ReadOnly =
    zio.aws.forecast.model.DeleteWhatIfForecastRequest.wrap(buildAwsValue())
}
object DeleteWhatIfForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteWhatIfForecastRequest =
      zio.aws.forecast.model.DeleteWhatIfForecastRequest(whatIfForecastArn)
    def whatIfForecastArn: LongArn
    def getWhatIfForecastArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(whatIfForecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest
  ) extends zio.aws.forecast.model.DeleteWhatIfForecastRequest.ReadOnly {
    override val whatIfForecastArn: LongArn =
      zio.aws.forecast.model.primitives.LongArn(impl.whatIfForecastArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteWhatIfForecastRequest
  ): zio.aws.forecast.model.DeleteWhatIfForecastRequest.ReadOnly = new Wrapper(
    impl
  )
}
