package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Frequency,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetResponse(
    datasetArn: Optional[Arn] = Optional.Absent,
    datasetName: Optional[Name] = Optional.Absent,
    domain: Optional[zio.aws.forecast.model.Domain] = Optional.Absent,
    datasetType: Optional[zio.aws.forecast.model.DatasetType] = Optional.Absent,
    dataFrequency: Optional[Frequency] = Optional.Absent,
    schema: Optional[zio.aws.forecast.model.Schema] = Optional.Absent,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse = {
    import DescribeDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse
      .builder()
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        dataFrequency.map(value => Frequency.unwrap(value): java.lang.String)
      )(_.dataFrequency)
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetResponse.wrap(buildAwsValue())
}
object DescribeDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetResponse =
      zio.aws.forecast.model.DescribeDatasetResponse(
        datasetArn.map(value => value),
        datasetName.map(value => value),
        domain.map(value => value),
        datasetType.map(value => value),
        dataFrequency.map(value => value),
        schema.map(value => value.asEditable),
        encryptionConfig.map(value => value.asEditable),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetArn: Optional[Arn]
    def datasetName: Optional[Name]
    def domain: Optional[zio.aws.forecast.model.Domain]
    def datasetType: Optional[zio.aws.forecast.model.DatasetType]
    def dataFrequency: Optional[Frequency]
    def schema: Optional[zio.aws.forecast.model.Schema.ReadOnly]
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDomain: ZIO[Any, AwsError, zio.aws.forecast.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getDatasetType: ZIO[Any, AwsError, zio.aws.forecast.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDataFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("dataFrequency", dataFrequency)
    def getSchema: ZIO[Any, AwsError, zio.aws.forecast.model.Schema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse
  ) extends zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly {
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val domain: Optional[zio.aws.forecast.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.forecast.model.Domain.wrap(value))
    override val datasetType: Optional[zio.aws.forecast.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.forecast.model.DatasetType.wrap(value))
    override val dataFrequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.dataFrequency())
      .map(value => zio.aws.forecast.model.primitives.Frequency(value))
    override val schema: Optional[zio.aws.forecast.model.Schema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value => zio.aws.forecast.model.Schema.wrap(value))
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetResponse
  ): zio.aws.forecast.model.DescribeDatasetResponse.ReadOnly = new Wrapper(impl)
}
