package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Message,
  Timestamp,
  Arn,
  Name,
  Format
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeForecastExportJobResponse(
    forecastExportJobArn: Optional[Arn] = Optional.Absent,
    forecastExportJobName: Optional[Name] = Optional.Absent,
    forecastArn: Optional[Arn] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    format: Optional[Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse = {
    import DescribeForecastExportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse
      .builder()
      .optionallyWith(
        forecastExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastExportJobArn)
      .optionallyWith(
        forecastExportJobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.forecastExportJobName)
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        format.map(value => Format.unwrap(value): java.lang.String)
      )(_.format)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly =
    zio.aws.forecast.model.DescribeForecastExportJobResponse
      .wrap(buildAwsValue())
}
object DescribeForecastExportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeForecastExportJobResponse =
      zio.aws.forecast.model.DescribeForecastExportJobResponse(
        forecastExportJobArn.map(value => value),
        forecastExportJobName.map(value => value),
        forecastArn.map(value => value),
        destination.map(value => value.asEditable),
        message.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        format.map(value => value)
      )
    def forecastExportJobArn: Optional[Arn]
    def forecastExportJobName: Optional[Name]
    def forecastArn: Optional[Arn]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def message: Optional[Message]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def format: Optional[Format]
    def getForecastExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastExportJobArn", forecastExportJobArn)
    def getForecastExportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("forecastExportJobName", forecastExportJobName)
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getFormat: ZIO[Any, AwsError, Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse
  ) extends zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly {
    override val forecastExportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastExportJobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val format: Optional[Format] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => zio.aws.forecast.model.primitives.Format(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobResponse
  ): zio.aws.forecast.model.DescribeForecastExportJobResponse.ReadOnly =
    new Wrapper(impl)
}
