package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  ErrorMessage,
  ForecastType,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeForecastResponse(
    forecastArn: Optional[Arn] = Optional.Absent,
    forecastName: Optional[Name] = Optional.Absent,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    predictorArn: Optional[Arn] = Optional.Absent,
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    timeSeriesSelector: Optional[zio.aws.forecast.model.TimeSeriesSelector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeForecastResponse = {
    import DescribeForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeForecastResponse
      .builder()
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(
        forecastName.map(value => Name.unwrap(value): java.lang.String)
      )(_.forecastName)
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(timeSeriesSelector.map(value => value.buildAwsValue()))(
        _.timeSeriesSelector
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeForecastResponse.ReadOnly =
    zio.aws.forecast.model.DescribeForecastResponse.wrap(buildAwsValue())
}
object DescribeForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeForecastResponse =
      zio.aws.forecast.model.DescribeForecastResponse(
        forecastArn.map(value => value),
        forecastName.map(value => value),
        forecastTypes.map(value => value),
        predictorArn.map(value => value),
        datasetGroupArn.map(value => value),
        estimatedTimeRemainingInMinutes.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        timeSeriesSelector.map(value => value.asEditable)
      )
    def forecastArn: Optional[Arn]
    def forecastName: Optional[Name]
    def forecastTypes: Optional[List[ForecastType]]
    def predictorArn: Optional[Arn]
    def datasetGroupArn: Optional[Arn]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def status: Optional[String]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly]
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getForecastName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("forecastName", forecastName)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getTimeSeriesSelector: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesSelector.ReadOnly
    ] = AwsError.unwrapOptionField("timeSeriesSelector", timeSeriesSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastResponse
  ) extends zio.aws.forecast.model.DescribeForecastResponse.ReadOnly {
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesSelector())
        .map(value => zio.aws.forecast.model.TimeSeriesSelector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastResponse
  ): zio.aws.forecast.model.DescribeForecastResponse.ReadOnly = new Wrapper(
    impl
  )
}
