package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeMonitorRequest(monitorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest = {
    import DescribeMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest
      .builder()
      .monitorArn(Arn.unwrap(monitorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeMonitorRequest.ReadOnly =
    zio.aws.forecast.model.DescribeMonitorRequest.wrap(buildAwsValue())
}
object DescribeMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeMonitorRequest =
      zio.aws.forecast.model.DescribeMonitorRequest(monitorArn)
    def monitorArn: Arn
    def getMonitorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(monitorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest
  ) extends zio.aws.forecast.model.DescribeMonitorRequest.ReadOnly {
    override val monitorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.monitorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeMonitorRequest
  ): zio.aws.forecast.model.DescribeMonitorRequest.ReadOnly = new Wrapper(impl)
}
