package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, ErrorMessage, Arn, Name}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeWhatIfAnalysisResponse(
    whatIfAnalysisName: Optional[Name] = Optional.Absent,
    whatIfAnalysisArn: Optional[Arn] = Optional.Absent,
    forecastArn: Optional[Arn] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    timeSeriesSelector: Optional[zio.aws.forecast.model.TimeSeriesSelector] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse = {
    import DescribeWhatIfAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse
      .builder()
      .optionallyWith(
        whatIfAnalysisName.map(value => Name.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisName)
      .optionallyWith(
        whatIfAnalysisArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisArn)
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(timeSeriesSelector.map(value => value.buildAwsValue()))(
        _.timeSeriesSelector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.wrap(buildAwsValue())
}
object DescribeWhatIfAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeWhatIfAnalysisResponse =
      zio.aws.forecast.model.DescribeWhatIfAnalysisResponse(
        whatIfAnalysisName.map(value => value),
        whatIfAnalysisArn.map(value => value),
        forecastArn.map(value => value),
        estimatedTimeRemainingInMinutes.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        timeSeriesSelector.map(value => value.asEditable)
      )
    def whatIfAnalysisName: Optional[Name]
    def whatIfAnalysisArn: Optional[Arn]
    def forecastArn: Optional[Arn]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def status: Optional[String]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly]
    def getWhatIfAnalysisName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("whatIfAnalysisName", whatIfAnalysisName)
    def getWhatIfAnalysisArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("whatIfAnalysisArn", whatIfAnalysisArn)
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getTimeSeriesSelector: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesSelector.ReadOnly
    ] = AwsError.unwrapOptionField("timeSeriesSelector", timeSeriesSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse
  ) extends zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly {
    override val whatIfAnalysisName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val whatIfAnalysisArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val timeSeriesSelector
        : Optional[zio.aws.forecast.model.TimeSeriesSelector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeSeriesSelector())
        .map(value => zio.aws.forecast.model.TimeSeriesSelector.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfAnalysisResponse
  ): zio.aws.forecast.model.DescribeWhatIfAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
