package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWhatIfForecastExportRequest(
    whatIfForecastExportArn: LongArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest = {
    import DescribeWhatIfForecastExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest
      .builder()
      .whatIfForecastExportArn(
        LongArn.unwrap(whatIfForecastExportArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfForecastExportRequest.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfForecastExportRequest
      .wrap(buildAwsValue())
}
object DescribeWhatIfForecastExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeWhatIfForecastExportRequest =
      zio.aws.forecast.model
        .DescribeWhatIfForecastExportRequest(whatIfForecastExportArn)
    def whatIfForecastExportArn: LongArn
    def getWhatIfForecastExportArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(whatIfForecastExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest
  ) extends zio.aws.forecast.model.DescribeWhatIfForecastExportRequest.ReadOnly {
    override val whatIfForecastExportArn: LongArn =
      zio.aws.forecast.model.primitives.LongArn(impl.whatIfForecastExportArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastExportRequest
  ): zio.aws.forecast.model.DescribeWhatIfForecastExportRequest.ReadOnly =
    new Wrapper(impl)
}
