package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.LongArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWhatIfForecastRequest(whatIfForecastArn: LongArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest = {
    import DescribeWhatIfForecastRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest
      .builder()
      .whatIfForecastArn(LongArn.unwrap(whatIfForecastArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfForecastRequest.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfForecastRequest.wrap(buildAwsValue())
}
object DescribeWhatIfForecastRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeWhatIfForecastRequest =
      zio.aws.forecast.model.DescribeWhatIfForecastRequest(whatIfForecastArn)
    def whatIfForecastArn: LongArn
    def getWhatIfForecastArn: ZIO[Any, Nothing, LongArn] =
      ZIO.succeed(whatIfForecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest
  ) extends zio.aws.forecast.model.DescribeWhatIfForecastRequest.ReadOnly {
    override val whatIfForecastArn: LongArn =
      zio.aws.forecast.model.primitives.LongArn(impl.whatIfForecastArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastRequest
  ): zio.aws.forecast.model.DescribeWhatIfForecastRequest.ReadOnly =
    new Wrapper(impl)
}
