package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  LongArn,
  ErrorMessage,
  ForecastType,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeWhatIfForecastResponse(
    whatIfForecastName: Optional[Name] = Optional.Absent,
    whatIfForecastArn: Optional[LongArn] = Optional.Absent,
    whatIfAnalysisArn: Optional[Arn] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    timeSeriesTransformations: Optional[
      Iterable[zio.aws.forecast.model.TimeSeriesTransformation]
    ] = Optional.Absent,
    timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource
    ] = Optional.Absent,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse = {
    import DescribeWhatIfForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse
      .builder()
      .optionallyWith(
        whatIfForecastName.map(value => Name.unwrap(value): java.lang.String)
      )(_.whatIfForecastName)
      .optionallyWith(
        whatIfForecastArn.map(value => LongArn.unwrap(value): java.lang.String)
      )(_.whatIfForecastArn)
      .optionallyWith(
        whatIfAnalysisArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.whatIfAnalysisArn)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        timeSeriesTransformations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeSeriesTransformations)
      .optionallyWith(
        timeSeriesReplacementsDataSource.map(value => value.buildAwsValue())
      )(_.timeSeriesReplacementsDataSource)
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly =
    zio.aws.forecast.model.DescribeWhatIfForecastResponse.wrap(buildAwsValue())
}
object DescribeWhatIfForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeWhatIfForecastResponse =
      zio.aws.forecast.model.DescribeWhatIfForecastResponse(
        whatIfForecastName.map(value => value),
        whatIfForecastArn.map(value => value),
        whatIfAnalysisArn.map(value => value),
        estimatedTimeRemainingInMinutes.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        timeSeriesTransformations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeSeriesReplacementsDataSource.map(value => value.asEditable),
        forecastTypes.map(value => value)
      )
    def whatIfForecastName: Optional[Name]
    def whatIfForecastArn: Optional[LongArn]
    def whatIfAnalysisArn: Optional[Arn]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def status: Optional[String]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def timeSeriesTransformations: Optional[
      List[zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly]
    ]
    def timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ]
    def forecastTypes: Optional[List[ForecastType]]
    def getWhatIfForecastName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("whatIfForecastName", whatIfForecastName)
    def getWhatIfForecastArn: ZIO[Any, AwsError, LongArn] =
      AwsError.unwrapOptionField("whatIfForecastArn", whatIfForecastArn)
    def getWhatIfAnalysisArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("whatIfAnalysisArn", whatIfAnalysisArn)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getTimeSeriesTransformations: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "timeSeriesTransformations",
      timeSeriesTransformations
    )
    def getTimeSeriesReplacementsDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesReplacementsDataSource",
      timeSeriesReplacementsDataSource
    )
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse
  ) extends zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly {
    override val whatIfForecastName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val whatIfForecastArn: Optional[LongArn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecastArn())
      .map(value => zio.aws.forecast.model.primitives.LongArn(value))
    override val whatIfAnalysisArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalysisArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val timeSeriesTransformations: Optional[
      List[zio.aws.forecast.model.TimeSeriesTransformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesTransformations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.TimeSeriesTransformation.wrap(item)
        }.toList
      )
    override val timeSeriesReplacementsDataSource: Optional[
      zio.aws.forecast.model.TimeSeriesReplacementsDataSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesReplacementsDataSource())
      .map(value =>
        zio.aws.forecast.model.TimeSeriesReplacementsDataSource.wrap(value)
      )
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeWhatIfForecastResponse
  ): zio.aws.forecast.model.DescribeWhatIfForecastResponse.ReadOnly =
    new Wrapper(impl)
}
