package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Filter(
    key: String,
    value: Arn,
    condition: zio.aws.forecast.model.FilterConditionString
) {
  def buildAwsValue(): software.amazon.awssdk.services.forecast.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Filter
      .builder()
      .key(key: java.lang.String)
      .value(Arn.unwrap(value): java.lang.String)
      .condition(condition.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Filter.ReadOnly =
    zio.aws.forecast.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Filter =
      zio.aws.forecast.model.Filter(key, value, condition)
    def key: String
    def value: Arn
    def condition: zio.aws.forecast.model.FilterConditionString
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, Arn] = ZIO.succeed(value)
    def getCondition
        : ZIO[Any, Nothing, zio.aws.forecast.model.FilterConditionString] =
      ZIO.succeed(condition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Filter
  ) extends zio.aws.forecast.model.Filter.ReadOnly {
    override val key: String = impl.key(): String
    override val value: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.value())
    override val condition: zio.aws.forecast.model.FilterConditionString =
      zio.aws.forecast.model.FilterConditionString.wrap(impl.condition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Filter
  ): zio.aws.forecast.model.Filter.ReadOnly = new Wrapper(impl)
}
