package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ForecastExportJobSummary(
    forecastExportJobArn: Optional[Arn] = Optional.Absent,
    forecastExportJobName: Optional[Name] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary = {
    import ForecastExportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary
      .builder()
      .optionallyWith(
        forecastExportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastExportJobArn)
      .optionallyWith(
        forecastExportJobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.forecastExportJobName)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly =
    zio.aws.forecast.model.ForecastExportJobSummary.wrap(buildAwsValue())
}
object ForecastExportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ForecastExportJobSummary =
      zio.aws.forecast.model.ForecastExportJobSummary(
        forecastExportJobArn.map(value => value),
        forecastExportJobName.map(value => value),
        destination.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def forecastExportJobArn: Optional[Arn]
    def forecastExportJobName: Optional[Name]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getForecastExportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastExportJobArn", forecastExportJobArn)
    def getForecastExportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("forecastExportJobName", forecastExportJobName)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary
  ) extends zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly {
    override val forecastExportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val forecastExportJobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary
  ): zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
