package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAccuracyMetricsRequest(predictorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest = {
    import GetAccuracyMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest
      .builder()
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.GetAccuracyMetricsRequest.ReadOnly =
    zio.aws.forecast.model.GetAccuracyMetricsRequest.wrap(buildAwsValue())
}
object GetAccuracyMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.GetAccuracyMetricsRequest =
      zio.aws.forecast.model.GetAccuracyMetricsRequest(predictorArn)
    def predictorArn: Arn
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest
  ) extends zio.aws.forecast.model.GetAccuracyMetricsRequest.ReadOnly {
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.GetAccuracyMetricsRequest
  ): zio.aws.forecast.model.GetAccuracyMetricsRequest.ReadOnly = new Wrapper(
    impl
  )
}
