package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListForecastsResponse(
    forecasts: Optional[Iterable[zio.aws.forecast.model.ForecastSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListForecastsResponse = {
    import ListForecastsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListForecastsResponse
      .builder()
      .optionallyWith(
        forecasts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.forecasts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListForecastsResponse.ReadOnly =
    zio.aws.forecast.model.ListForecastsResponse.wrap(buildAwsValue())
}
object ListForecastsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListForecastsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListForecastsResponse =
      zio.aws.forecast.model.ListForecastsResponse(
        forecasts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def forecasts
        : Optional[List[zio.aws.forecast.model.ForecastSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getForecasts: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ForecastSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("forecasts", forecasts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListForecastsResponse
  ) extends zio.aws.forecast.model.ListForecastsResponse.ReadOnly {
    override val forecasts
        : Optional[List[zio.aws.forecast.model.ForecastSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecasts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.ForecastSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListForecastsResponse
  ): zio.aws.forecast.model.ListForecastsResponse.ReadOnly = new Wrapper(impl)
}
