package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMonitorEvaluationsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    predictorMonitorEvaluations: Optional[
      Iterable[zio.aws.forecast.model.PredictorMonitorEvaluation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse = {
    import ListMonitorEvaluationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        predictorMonitorEvaluations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predictorMonitorEvaluations)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly =
    zio.aws.forecast.model.ListMonitorEvaluationsResponse.wrap(buildAwsValue())
}
object ListMonitorEvaluationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListMonitorEvaluationsResponse =
      zio.aws.forecast.model.ListMonitorEvaluationsResponse(
        nextToken.map(value => value),
        predictorMonitorEvaluations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def predictorMonitorEvaluations: Optional[
      List[zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPredictorMonitorEvaluations: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "predictorMonitorEvaluations",
      predictorMonitorEvaluations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse
  ) extends zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
    override val predictorMonitorEvaluations: Optional[
      List[zio.aws.forecast.model.PredictorMonitorEvaluation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorMonitorEvaluations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.PredictorMonitorEvaluation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListMonitorEvaluationsResponse
  ): zio.aws.forecast.model.ListMonitorEvaluationsResponse.ReadOnly =
    new Wrapper(impl)
}
