package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMonitorsResponse(
    monitors: Optional[Iterable[zio.aws.forecast.model.MonitorSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListMonitorsResponse = {
    import ListMonitorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListMonitorsResponse
      .builder()
      .optionallyWith(
        monitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitors)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListMonitorsResponse.ReadOnly =
    zio.aws.forecast.model.ListMonitorsResponse.wrap(buildAwsValue())
}
object ListMonitorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListMonitorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListMonitorsResponse =
      zio.aws.forecast.model.ListMonitorsResponse(
        monitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def monitors: Optional[List[zio.aws.forecast.model.MonitorSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getMonitors: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.MonitorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("monitors", monitors)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListMonitorsResponse
  ) extends zio.aws.forecast.model.ListMonitorsResponse.ReadOnly {
    override val monitors
        : Optional[List[zio.aws.forecast.model.MonitorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.MonitorSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListMonitorsResponse
  ): zio.aws.forecast.model.ListMonitorsResponse.ReadOnly = new Wrapper(impl)
}
