package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPredictorBacktestExportJobsResponse(
    predictorBacktestExportJobs: Optional[
      Iterable[zio.aws.forecast.model.PredictorBacktestExportJobSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse = {
    import ListPredictorBacktestExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse
      .builder()
      .optionallyWith(
        predictorBacktestExportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.predictorBacktestExportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly =
    zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse
      .wrap(buildAwsValue())
}
object ListPredictorBacktestExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse =
      zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse(
        predictorBacktestExportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def predictorBacktestExportJobs: Optional[
      List[zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPredictorBacktestExportJobs: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "predictorBacktestExportJobs",
      predictorBacktestExportJobs
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse
  ) extends zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly {
    override val predictorBacktestExportJobs: Optional[
      List[zio.aws.forecast.model.PredictorBacktestExportJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorBacktestExportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.PredictorBacktestExportJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListPredictorBacktestExportJobsResponse
  ): zio.aws.forecast.model.ListPredictorBacktestExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
