package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWhatIfAnalysesResponse(
    whatIfAnalyses: Optional[
      Iterable[zio.aws.forecast.model.WhatIfAnalysisSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse = {
    import ListWhatIfAnalysesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse
      .builder()
      .optionallyWith(
        whatIfAnalyses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whatIfAnalyses)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly =
    zio.aws.forecast.model.ListWhatIfAnalysesResponse.wrap(buildAwsValue())
}
object ListWhatIfAnalysesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListWhatIfAnalysesResponse =
      zio.aws.forecast.model.ListWhatIfAnalysesResponse(
        whatIfAnalyses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def whatIfAnalyses
        : Optional[List[zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getWhatIfAnalyses: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("whatIfAnalyses", whatIfAnalyses)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse
  ) extends zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly {
    override val whatIfAnalyses: Optional[
      List[zio.aws.forecast.model.WhatIfAnalysisSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfAnalyses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.WhatIfAnalysisSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfAnalysesResponse
  ): zio.aws.forecast.model.ListWhatIfAnalysesResponse.ReadOnly = new Wrapper(
    impl
  )
}
