package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWhatIfForecastsResponse(
    whatIfForecasts: Optional[
      Iterable[zio.aws.forecast.model.WhatIfForecastSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse = {
    import ListWhatIfForecastsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse
      .builder()
      .optionallyWith(
        whatIfForecasts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.whatIfForecasts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly =
    zio.aws.forecast.model.ListWhatIfForecastsResponse.wrap(buildAwsValue())
}
object ListWhatIfForecastsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListWhatIfForecastsResponse =
      zio.aws.forecast.model.ListWhatIfForecastsResponse(
        whatIfForecasts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def whatIfForecasts
        : Optional[List[zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getWhatIfForecasts: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("whatIfForecasts", whatIfForecasts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse
  ) extends zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly {
    override val whatIfForecasts: Optional[
      List[zio.aws.forecast.model.WhatIfForecastSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.whatIfForecasts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.WhatIfForecastSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse
  ): zio.aws.forecast.model.ListWhatIfForecastsResponse.ReadOnly = new Wrapper(
    impl
  )
}
