package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MonitorConfig(monitorName: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.MonitorConfig = {
    import MonitorConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.MonitorConfig
      .builder()
      .monitorName(Name.unwrap(monitorName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.MonitorConfig.ReadOnly =
    zio.aws.forecast.model.MonitorConfig.wrap(buildAwsValue())
}
object MonitorConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.MonitorConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.MonitorConfig =
      zio.aws.forecast.model.MonitorConfig(monitorName)
    def monitorName: Name
    def getMonitorName: ZIO[Any, Nothing, Name] = ZIO.succeed(monitorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.MonitorConfig
  ) extends zio.aws.forecast.model.MonitorConfig.ReadOnly {
    override val monitorName: Name =
      zio.aws.forecast.model.primitives.Name(impl.monitorName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.MonitorConfig
  ): zio.aws.forecast.model.MonitorConfig.ReadOnly = new Wrapper(impl)
}
