package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Status, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitorInfo(
    monitorArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.MonitorInfo = {
    import MonitorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.MonitorInfo
      .builder()
      .optionallyWith(
        monitorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.monitorArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.MonitorInfo.ReadOnly =
    zio.aws.forecast.model.MonitorInfo.wrap(buildAwsValue())
}
object MonitorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.MonitorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.MonitorInfo = zio.aws.forecast.model
      .MonitorInfo(monitorArn.map(value => value), status.map(value => value))
    def monitorArn: Optional[Arn]
    def status: Optional[Status]
    def getMonitorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("monitorArn", monitorArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.MonitorInfo
  ) extends zio.aws.forecast.model.MonitorInfo.ReadOnly {
    override val monitorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.monitorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.MonitorInfo
  ): zio.aws.forecast.model.MonitorInfo.ReadOnly = new Wrapper(impl)
}
