package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait Operation {
  def unwrap: software.amazon.awssdk.services.forecast.model.Operation
}
object Operation {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.Operation
  ): zio.aws.forecast.model.Operation = value match {
    case software.amazon.awssdk.services.forecast.model.Operation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.Operation.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.forecast.model.Operation.SUBTRACT =>
      val r = SUBTRACT
      r
    case software.amazon.awssdk.services.forecast.model.Operation.MULTIPLY =>
      val r = MULTIPLY
      r
    case software.amazon.awssdk.services.forecast.model.Operation.DIVIDE =>
      val r = DIVIDE
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Operation =
      software.amazon.awssdk.services.forecast.model.Operation.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.forecast.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Operation =
      software.amazon.awssdk.services.forecast.model.Operation.ADD
  }
  case object SUBTRACT extends zio.aws.forecast.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Operation =
      software.amazon.awssdk.services.forecast.model.Operation.SUBTRACT
  }
  case object MULTIPLY extends zio.aws.forecast.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Operation =
      software.amazon.awssdk.services.forecast.model.Operation.MULTIPLY
  }
  case object DIVIDE extends zio.aws.forecast.model.Operation {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.Operation =
      software.amazon.awssdk.services.forecast.model.Operation.DIVIDE
  }
}
