package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PredictorBaseline(
    baselineMetrics: Optional[Iterable[zio.aws.forecast.model.BaselineMetric]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorBaseline = {
    import PredictorBaseline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorBaseline
      .builder()
      .optionallyWith(
        baselineMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baselineMetrics)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorBaseline.ReadOnly =
    zio.aws.forecast.model.PredictorBaseline.wrap(buildAwsValue())
}
object PredictorBaseline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorBaseline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorBaseline =
      zio.aws.forecast.model.PredictorBaseline(
        baselineMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def baselineMetrics
        : Optional[List[zio.aws.forecast.model.BaselineMetric.ReadOnly]]
    def getBaselineMetrics: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.BaselineMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("baselineMetrics", baselineMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorBaseline
  ) extends zio.aws.forecast.model.PredictorBaseline.ReadOnly {
    override val baselineMetrics
        : Optional[List[zio.aws.forecast.model.BaselineMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.BaselineMetric.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorBaseline
  ): zio.aws.forecast.model.PredictorBaseline.ReadOnly = new Wrapper(impl)
}
