package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait ScalingType {
  def unwrap: software.amazon.awssdk.services.forecast.model.ScalingType
}
object ScalingType {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.ScalingType
  ): zio.aws.forecast.model.ScalingType = value match {
    case software.amazon.awssdk.services.forecast.model.ScalingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.ScalingType.AUTO =>
      val r = Auto
      r
    case software.amazon.awssdk.services.forecast.model.ScalingType.LINEAR =>
      val r = Linear
      r
    case software.amazon.awssdk.services.forecast.model.ScalingType.LOGARITHMIC =>
      val r = Logarithmic
      r
    case software.amazon.awssdk.services.forecast.model.ScalingType.REVERSE_LOGARITHMIC =>
      val r = ReverseLogarithmic
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.ScalingType =
      software.amazon.awssdk.services.forecast.model.ScalingType.UNKNOWN_TO_SDK_VERSION
  }
  case object Auto extends zio.aws.forecast.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.ScalingType =
      software.amazon.awssdk.services.forecast.model.ScalingType.AUTO
  }
  case object Linear extends zio.aws.forecast.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.ScalingType =
      software.amazon.awssdk.services.forecast.model.ScalingType.LINEAR
  }
  case object Logarithmic extends zio.aws.forecast.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.ScalingType =
      software.amazon.awssdk.services.forecast.model.ScalingType.LOGARITHMIC
  }
  case object ReverseLogarithmic extends zio.aws.forecast.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.ScalingType =
      software.amazon.awssdk.services.forecast.model.ScalingType.REVERSE_LOGARITHMIC
  }
}
