package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaAttribute(
    attributeName: Optional[Name] = Optional.Absent,
    attributeType: Optional[zio.aws.forecast.model.AttributeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.SchemaAttribute = {
    import SchemaAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.SchemaAttribute
      .builder()
      .optionallyWith(
        attributeName.map(value => Name.unwrap(value): java.lang.String)
      )(_.attributeName)
      .optionallyWith(attributeType.map(value => value.unwrap))(_.attributeType)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.SchemaAttribute.ReadOnly =
    zio.aws.forecast.model.SchemaAttribute.wrap(buildAwsValue())
}
object SchemaAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.SchemaAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.SchemaAttribute =
      zio.aws.forecast.model.SchemaAttribute(
        attributeName.map(value => value),
        attributeType.map(value => value)
      )
    def attributeName: Optional[Name]
    def attributeType: Optional[zio.aws.forecast.model.AttributeType]
    def getAttributeName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeType
        : ZIO[Any, AwsError, zio.aws.forecast.model.AttributeType] =
      AwsError.unwrapOptionField("attributeType", attributeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.SchemaAttribute
  ) extends zio.aws.forecast.model.SchemaAttribute.ReadOnly {
    override val attributeName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val attributeType: Optional[zio.aws.forecast.model.AttributeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeType())
        .map(value => zio.aws.forecast.model.AttributeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.SchemaAttribute
  ): zio.aws.forecast.model.SchemaAttribute.ReadOnly = new Wrapper(impl)
}
