package zio.aws.forecast.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Hour, DayOfMonth}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TimeAlignmentBoundary(
    month: Optional[zio.aws.forecast.model.Month] = Optional.Absent,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    dayOfWeek: Optional[zio.aws.forecast.model.DayOfWeek] = Optional.Absent,
    hour: Optional[Hour] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeAlignmentBoundary = {
    import TimeAlignmentBoundary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeAlignmentBoundary
      .builder()
      .optionallyWith(month.map(value => value.unwrap))(_.month)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): Integer)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .optionallyWith(hour.map(value => Hour.unwrap(value): Integer))(_.hour)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly =
    zio.aws.forecast.model.TimeAlignmentBoundary.wrap(buildAwsValue())
}
object TimeAlignmentBoundary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeAlignmentBoundary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeAlignmentBoundary =
      zio.aws.forecast.model.TimeAlignmentBoundary(
        month.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value),
        hour.map(value => value)
      )
    def month: Optional[zio.aws.forecast.model.Month]
    def dayOfMonth: Optional[DayOfMonth]
    def dayOfWeek: Optional[zio.aws.forecast.model.DayOfWeek]
    def hour: Optional[Hour]
    def getMonth: ZIO[Any, AwsError, zio.aws.forecast.model.Month] =
      AwsError.unwrapOptionField("month", month)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.forecast.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
    def getHour: ZIO[Any, AwsError, Hour] =
      AwsError.unwrapOptionField("hour", hour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeAlignmentBoundary
  ) extends zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly {
    override val month: Optional[zio.aws.forecast.model.Month] =
      zio.aws.core.internal
        .optionalFromNullable(impl.month())
        .map(value => zio.aws.forecast.model.Month.wrap(value))
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.forecast.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Optional[zio.aws.forecast.model.DayOfWeek] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dayOfWeek())
        .map(value => zio.aws.forecast.model.DayOfWeek.wrap(value))
    override val hour: Optional[Hour] = zio.aws.core.internal
      .optionalFromNullable(impl.hour())
      .map(value => zio.aws.forecast.model.primitives.Hour(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeAlignmentBoundary
  ): zio.aws.forecast.model.TimeAlignmentBoundary.ReadOnly = new Wrapper(impl)
}
