package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{AttributeValue, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TimeSeriesCondition(
    attributeName: Name,
    attributeValue: AttributeValue,
    condition: zio.aws.forecast.model.Condition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.TimeSeriesCondition = {
    import TimeSeriesCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.TimeSeriesCondition
      .builder()
      .attributeName(Name.unwrap(attributeName): java.lang.String)
      .attributeValue(AttributeValue.unwrap(attributeValue): java.lang.String)
      .condition(condition.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.TimeSeriesCondition.ReadOnly =
    zio.aws.forecast.model.TimeSeriesCondition.wrap(buildAwsValue())
}
object TimeSeriesCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.TimeSeriesCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.TimeSeriesCondition =
      zio.aws.forecast.model
        .TimeSeriesCondition(attributeName, attributeValue, condition)
    def attributeName: Name
    def attributeValue: AttributeValue
    def condition: zio.aws.forecast.model.Condition
    def getAttributeName: ZIO[Any, Nothing, Name] = ZIO.succeed(attributeName)
    def getAttributeValue: ZIO[Any, Nothing, AttributeValue] =
      ZIO.succeed(attributeValue)
    def getCondition: ZIO[Any, Nothing, zio.aws.forecast.model.Condition] =
      ZIO.succeed(condition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesCondition
  ) extends zio.aws.forecast.model.TimeSeriesCondition.ReadOnly {
    override val attributeName: Name =
      zio.aws.forecast.model.primitives.Name(impl.attributeName())
    override val attributeValue: AttributeValue =
      zio.aws.forecast.model.primitives.AttributeValue(impl.attributeValue())
    override val condition: zio.aws.forecast.model.Condition =
      zio.aws.forecast.model.Condition.wrap(impl.condition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.TimeSeriesCondition
  ): zio.aws.forecast.model.TimeSeriesCondition.ReadOnly = new Wrapper(impl)
}
